/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;

public class FoodData {
    private int foodLevel = 20;
    private float saturationLevel = 5.0f;
    private float exhaustionLevel;
    private int tickTimer;
    private int lastFoodLevel = 20;

    public void eat(int pFoodLevelModifier, float pSaturationLevelModifier) {
        this.foodLevel = Math.min(pFoodLevelModifier + this.foodLevel, 20);
        this.saturationLevel = Math.min(this.saturationLevel + (float)pFoodLevelModifier * pSaturationLevelModifier * 2.0f, (float)this.foodLevel);
    }

    public void eat(Item pFoodLevelModifier, ItemStack pSaturationLevelModifier) {
        if (pFoodLevelModifier.isEdible()) {
            FoodProperties foodproperties = pFoodLevelModifier.getFoodProperties();
            this.eat(foodproperties.getNutrition(), foodproperties.getSaturationModifier());
        }
    }

    public void tick(Player pPlayer) {
        boolean flag;
        Difficulty difficulty = pPlayer.level.getDifficulty();
        this.lastFoodLevel = this.foodLevel;
        if (this.exhaustionLevel > 4.0f) {
            this.exhaustionLevel -= 4.0f;
            if (this.saturationLevel > 0.0f) {
                this.saturationLevel = Math.max(this.saturationLevel - 1.0f, 0.0f);
            } else if (difficulty != Difficulty.PEACEFUL) {
                this.foodLevel = Math.max(this.foodLevel - 1, 0);
            }
        }
        if ((flag = pPlayer.level.getGameRules().getBoolean(GameRules.RULE_NATURAL_REGENERATION)) && this.saturationLevel > 0.0f && pPlayer.isHurt() && this.foodLevel >= 20) {
            ++this.tickTimer;
            if (this.tickTimer >= 10) {
                float f = Math.min(this.saturationLevel, 6.0f);
                pPlayer.heal(f / 6.0f);
                this.addExhaustion(f);
                this.tickTimer = 0;
            }
        } else if (flag && this.foodLevel >= 18 && pPlayer.isHurt()) {
            ++this.tickTimer;
            if (this.tickTimer >= 80) {
                pPlayer.heal(1.0f);
                this.addExhaustion(6.0f);
                this.tickTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.tickTimer;
            if (this.tickTimer >= 80) {
                if (pPlayer.getHealth() > 10.0f || difficulty == Difficulty.HARD || pPlayer.getHealth() > 1.0f && difficulty == Difficulty.NORMAL) {
                    pPlayer.hurt(DamageSource.STARVE, 1.0f);
                }
                this.tickTimer = 0;
            }
        } else {
            this.tickTimer = 0;
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompoundTag) {
        if (pCompoundTag.contains("foodLevel", 99)) {
            this.foodLevel = pCompoundTag.getInt("foodLevel");
            this.tickTimer = pCompoundTag.getInt("foodTickTimer");
            this.saturationLevel = pCompoundTag.getFloat("foodSaturationLevel");
            this.exhaustionLevel = pCompoundTag.getFloat("foodExhaustionLevel");
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompoundTag) {
        pCompoundTag.putInt("foodLevel", this.foodLevel);
        pCompoundTag.putInt("foodTickTimer", this.tickTimer);
        pCompoundTag.putFloat("foodSaturationLevel", this.saturationLevel);
        pCompoundTag.putFloat("foodExhaustionLevel", this.exhaustionLevel);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public int getLastFoodLevel() {
        return this.lastFoodLevel;
    }

    public boolean needsFood() {
        return this.foodLevel < 20;
    }

    public void addExhaustion(float pExhaustion) {
        this.exhaustionLevel = Math.min(this.exhaustionLevel + pExhaustion, 40.0f);
    }

    public float getExhaustionLevel() {
        return this.exhaustionLevel;
    }

    public float getSaturationLevel() {
        return this.saturationLevel;
    }

    public void setFoodLevel(int pFoodLevel) {
        this.foodLevel = pFoodLevel;
    }

    public void setSaturation(float pSaturationLevel) {
        this.saturationLevel = pSaturationLevel;
    }

    public void setExhaustion(float pExhaustionLevel) {
        this.exhaustionLevel = pExhaustionLevel;
    }
}

