/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;

public abstract class AbstractContainerMenu {
    private static Logger LOGGER = LogUtils.getLogger();
    public static final int SLOT_CLICKED_OUTSIDE = -999;
    public static final int QUICKCRAFT_TYPE_CHARITABLE = 0;
    public static final int QUICKCRAFT_TYPE_GREEDY = 1;
    public static final int QUICKCRAFT_TYPE_CLONE = 2;
    public static final int QUICKCRAFT_HEADER_START = 0;
    public static final int QUICKCRAFT_HEADER_CONTINUE = 1;
    public static final int QUICKCRAFT_HEADER_END = 2;
    public static final int CARRIED_SLOT_SIZE = Integer.MAX_VALUE;
    private final NonNullList<ItemStack> lastSlots = NonNullList.create();
    public final NonNullList<Slot> slots = NonNullList.create();
    private final List<DataSlot> dataSlots = Lists.newArrayList();
    private ItemStack carried = ItemStack.EMPTY;
    private final NonNullList<ItemStack> remoteSlots = NonNullList.create();
    private final IntList remoteDataSlots = new IntArrayList();
    private ItemStack remoteCarried = ItemStack.EMPTY;
    private int stateId;
    @Nullable
    private final MenuType<?> menuType;
    public final int containerId;
    private int quickcraftType = -1;
    private int quickcraftStatus;
    private final Set<Slot> quickcraftSlots = Sets.newHashSet();
    private final List<ContainerListener> containerListeners = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer synchronizer;
    private boolean suppressRemoteUpdates;

    protected AbstractContainerMenu(@Nullable MenuType<?> pMenuType, int pContainerId) {
        this.menuType = pMenuType;
        this.containerId = pContainerId;
    }

    protected static boolean stillValid(ContainerLevelAccess pLevelPos, Player pPlayer, Block pTargetBlock) {
        return pLevelPos.evaluate((p_38916_, p_38917_) -> !p_38916_.getBlockState((BlockPos)p_38917_).is(pTargetBlock) ? false : pPlayer.distanceToSqr((double)p_38917_.getX() + 0.5, (double)p_38917_.getY() + 0.5, (double)p_38917_.getZ() + 0.5) <= 64.0, true);
    }

    public MenuType<?> getType() {
        if (this.menuType == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.menuType;
    }

    protected static void checkContainerSize(Container pInventory, int pMinSize) {
        int i = pInventory.getContainerSize();
        if (i < pMinSize) {
            throw new IllegalArgumentException("Container size " + i + " is smaller than expected " + pMinSize);
        }
    }

    protected static void checkContainerDataCount(ContainerData pIntArray, int pMinSize) {
        int i = pIntArray.getCount();
        if (i < pMinSize) {
            throw new IllegalArgumentException("Container data count " + i + " is smaller than expected " + pMinSize);
        }
    }

    public boolean isValidSlotIndex(int p_207776_) {
        return p_207776_ == -1 || p_207776_ == -999 || p_207776_ < this.slots.size();
    }

    protected Slot addSlot(Slot pSlot) {
        pSlot.index = this.slots.size();
        this.slots.add(pSlot);
        this.lastSlots.add(ItemStack.EMPTY);
        this.remoteSlots.add(ItemStack.EMPTY);
        return pSlot;
    }

    protected DataSlot addDataSlot(DataSlot pIntValue) {
        this.dataSlots.add(pIntValue);
        this.remoteDataSlots.add(0);
        return pIntValue;
    }

    protected void addDataSlots(ContainerData pArray) {
        int i = 0;
        while (i < pArray.getCount()) {
            this.addDataSlot(DataSlot.forContainer(pArray, i));
            ++i;
        }
    }

    public void addSlotListener(ContainerListener pListener) {
        if (!this.containerListeners.contains(pListener)) {
            this.containerListeners.add(pListener);
            this.broadcastChanges();
        }
    }

    public void setSynchronizer(ContainerSynchronizer p_150417_) {
        this.synchronizer = p_150417_;
        this.sendAllDataToRemote();
    }

    public void sendAllDataToRemote() {
        int i = 0;
        int j = this.slots.size();
        while (i < j) {
            this.remoteSlots.set(i, this.slots.get(i).getItem().copy());
            ++i;
        }
        this.remoteCarried = this.getCarried().copy();
        i = 0;
        int k = this.dataSlots.size();
        while (i < k) {
            this.remoteDataSlots.set(i, this.dataSlots.get(i).get());
            ++i;
        }
        if (this.synchronizer != null) {
            this.synchronizer.a(this, this.remoteSlots, this.remoteCarried, this.remoteDataSlots.toIntArray());
        }
    }

    public void removeSlotListener(ContainerListener pListener) {
        this.containerListeners.remove(pListener);
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList<ItemStack> nonnulllist = NonNullList.create();
        for (Slot slot : this.slots) {
            nonnulllist.add(slot.getItem());
        }
        return nonnulllist;
    }

    public void broadcastChanges() {
        int i = 0;
        while (i < this.slots.size()) {
            ItemStack itemstack = this.slots.get(i).getItem();
            Supplier supplier = Suppliers.memoize(itemstack::copy);
            this.triggerSlotListeners(i, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
            this.synchronizeSlotToRemote(i, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
            ++i;
        }
        this.synchronizeCarriedToRemote();
        int j = 0;
        while (j < this.dataSlots.size()) {
            DataSlot dataslot = this.dataSlots.get(j);
            int k = dataslot.get();
            if (dataslot.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(j, k);
            }
            this.synchronizeDataSlotToRemote(j, k);
            ++j;
        }
    }

    public void broadcastFullState() {
        int i = 0;
        while (i < this.slots.size()) {
            ItemStack itemstack = this.slots.get(i).getItem();
            this.triggerSlotListeners(i, itemstack, itemstack::copy);
            ++i;
        }
        int j = 0;
        while (j < this.dataSlots.size()) {
            DataSlot dataslot = this.dataSlots.get(j);
            if (dataslot.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(j, dataslot.get());
            }
            ++j;
        }
        this.sendAllDataToRemote();
    }

    private void updateDataSlotListeners(int p_182421_, int p_182422_) {
        for (ContainerListener containerlistener : this.containerListeners) {
            containerlistener.dataChanged(this, p_182421_, p_182422_);
        }
    }

    private void triggerSlotListeners(int p_150408_, ItemStack p_150409_, java.util.function.Supplier<ItemStack> p_150410_) {
        ItemStack itemstack = this.lastSlots.get(p_150408_);
        if (!ItemStack.matches(itemstack, p_150409_)) {
            ItemStack itemstack1 = p_150410_.get();
            this.lastSlots.set(p_150408_, itemstack1);
            for (ContainerListener containerlistener : this.containerListeners) {
                containerlistener.slotChanged(this, p_150408_, itemstack1);
            }
        }
    }

    private void synchronizeSlotToRemote(int p_150436_, ItemStack p_150437_, java.util.function.Supplier<ItemStack> p_150438_) {
        ItemStack itemstack;
        if (!this.suppressRemoteUpdates && !ItemStack.matches(itemstack = this.remoteSlots.get(p_150436_), p_150437_)) {
            ItemStack itemstack1 = p_150438_.get();
            this.remoteSlots.set(p_150436_, itemstack1);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange(this, p_150436_, itemstack1);
            }
        }
    }

    private void synchronizeDataSlotToRemote(int p_150441_, int p_150442_) {
        int i;
        if (!this.suppressRemoteUpdates && (i = this.remoteDataSlots.getInt(p_150441_)) != p_150442_) {
            this.remoteDataSlots.set(p_150441_, p_150442_);
            if (this.synchronizer != null) {
                this.synchronizer.sendDataChange(this, p_150441_, p_150442_);
            }
        }
    }

    private void synchronizeCarriedToRemote() {
        if (!this.suppressRemoteUpdates && !ItemStack.matches(this.getCarried(), this.remoteCarried)) {
            this.remoteCarried = this.getCarried().copy();
            if (this.synchronizer != null) {
                this.synchronizer.sendCarriedChange(this, this.remoteCarried);
            }
        }
    }

    public void setRemoteSlot(int p_150405_, ItemStack p_150406_) {
        this.remoteSlots.set(p_150405_, p_150406_.copy());
    }

    public void setRemoteSlotNoCopy(int p_182415_, ItemStack p_182416_) {
        if (p_182415_ >= 0 && p_182415_ < this.remoteSlots.size()) {
            this.remoteSlots.set(p_182415_, p_182416_);
        } else {
            LOGGER.debug("Incorrect slot index: {} available slots: {}", (Object)p_182415_, (Object)this.remoteSlots.size());
        }
    }

    public void setRemoteCarried(ItemStack p_150423_) {
        this.remoteCarried = p_150423_.copy();
    }

    public boolean clickMenuButton(Player pPlayer, int pId) {
        return false;
    }

    public Slot getSlot(int pSlotId) {
        return this.slots.get(pSlotId);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        return this.slots.get(pIndex).getItem();
    }

    public void clicked(int p_150400_, int p_150401_, ClickType p_150402_, Player p_150403_) {
        try {
            this.doClick(p_150400_, p_150401_, p_150402_, p_150403_);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.forThrowable(exception, "Container click");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Click info");
            crashreportcategory.setDetail("Menu Type", () -> this.menuType != null ? Registry.MENU.getKey(this.menuType).toString() : "<no type>");
            crashreportcategory.setDetail("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportcategory.setDetail("Slot Count", this.slots.size());
            crashreportcategory.setDetail("Slot", p_150400_);
            crashreportcategory.setDetail("Button", p_150401_);
            crashreportcategory.setDetail("Type", (Object)p_150402_);
            throw new ReportedException(crashreport);
        }
    }

    private void doClick(int p_150431_, int p_150432_, ClickType p_150433_, Player p_150434_) {
        block41: {
            block52: {
                block48: {
                    ItemStack itemstack7;
                    ItemStack itemstack4;
                    Slot slot2;
                    Inventory inventory;
                    block51: {
                        block50: {
                            block49: {
                                block46: {
                                    ClickAction clickaction;
                                    block47: {
                                        block45: {
                                            block39: {
                                                block44: {
                                                    ItemStack itemstack;
                                                    block43: {
                                                        block42: {
                                                            block40: {
                                                                inventory = p_150434_.getInventory();
                                                                if (p_150433_ != ClickType.QUICK_CRAFT) break block39;
                                                                int i = this.quickcraftStatus;
                                                                this.quickcraftStatus = AbstractContainerMenu.getQuickcraftHeader(p_150432_);
                                                                if (i == 1 && this.quickcraftStatus == 2 || i == this.quickcraftStatus) break block40;
                                                                this.resetQuickCraft();
                                                                break block41;
                                                            }
                                                            if (!this.getCarried().isEmpty()) break block42;
                                                            this.resetQuickCraft();
                                                            break block41;
                                                        }
                                                        if (this.quickcraftStatus != 0) break block43;
                                                        this.quickcraftType = AbstractContainerMenu.getQuickcraftType(p_150432_);
                                                        if (AbstractContainerMenu.isValidQuickcraftType(this.quickcraftType, p_150434_)) {
                                                            this.quickcraftStatus = 1;
                                                            this.quickcraftSlots.clear();
                                                        } else {
                                                            this.resetQuickCraft();
                                                        }
                                                        break block41;
                                                    }
                                                    if (this.quickcraftStatus != 1) break block44;
                                                    Slot slot = this.slots.get(p_150431_);
                                                    if (!AbstractContainerMenu.canItemQuickReplace(slot, itemstack = this.getCarried(), true) || !slot.mayPlace(itemstack) || this.quickcraftType != 2 && itemstack.getCount() <= this.quickcraftSlots.size() || !this.canDragTo(slot)) break block41;
                                                    this.quickcraftSlots.add(slot);
                                                    break block41;
                                                }
                                                if (this.quickcraftStatus == 2) {
                                                    if (!this.quickcraftSlots.isEmpty()) {
                                                        if (this.quickcraftSlots.size() == 1) {
                                                            int l = this.quickcraftSlots.iterator().next().index;
                                                            this.resetQuickCraft();
                                                            this.doClick(l, this.quickcraftType, ClickType.PICKUP, p_150434_);
                                                            return;
                                                        }
                                                        ItemStack itemstack3 = this.getCarried().copy();
                                                        int j1 = this.getCarried().getCount();
                                                        for (Slot slot1 : this.quickcraftSlots) {
                                                            ItemStack itemstack1 = this.getCarried();
                                                            if (slot1 == null || !AbstractContainerMenu.canItemQuickReplace(slot1, itemstack1, true) || !slot1.mayPlace(itemstack1) || this.quickcraftType != 2 && itemstack1.getCount() < this.quickcraftSlots.size() || !this.canDragTo(slot1)) continue;
                                                            ItemStack itemstack2 = itemstack3.copy();
                                                            int j = slot1.hasItem() ? slot1.getItem().getCount() : 0;
                                                            AbstractContainerMenu.getQuickCraftSlotCount(this.quickcraftSlots, this.quickcraftType, itemstack2, j);
                                                            int k = Math.min(itemstack2.getMaxStackSize(), slot1.getMaxStackSize(itemstack2));
                                                            if (itemstack2.getCount() > k) {
                                                                itemstack2.setCount(k);
                                                            }
                                                            j1 -= itemstack2.getCount() - j;
                                                            slot1.set(itemstack2);
                                                        }
                                                        itemstack3.setCount(j1);
                                                        this.setCarried(itemstack3);
                                                    }
                                                    this.resetQuickCraft();
                                                } else {
                                                    this.resetQuickCraft();
                                                }
                                                break block41;
                                            }
                                            if (this.quickcraftStatus == 0) break block45;
                                            this.resetQuickCraft();
                                            break block41;
                                        }
                                        if (p_150433_ != ClickType.PICKUP && p_150433_ != ClickType.QUICK_MOVE || p_150432_ != 0 && p_150432_ != 1) break block46;
                                        ClickAction clickAction = clickaction = p_150432_ == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                                        if (p_150431_ != -999) break block47;
                                        if (this.getCarried().isEmpty()) break block41;
                                        if (clickaction == ClickAction.PRIMARY) {
                                            p_150434_.drop(this.getCarried(), true);
                                            this.setCarried(ItemStack.EMPTY);
                                        } else {
                                            p_150434_.drop(this.getCarried().split(1), true);
                                        }
                                        break block41;
                                    }
                                    if (p_150433_ == ClickType.QUICK_MOVE) {
                                        if (p_150431_ < 0) {
                                            return;
                                        }
                                        Slot slot6 = this.slots.get(p_150431_);
                                        if (!slot6.mayPickup(p_150434_)) {
                                            return;
                                        }
                                        ItemStack itemstack9 = this.quickMoveStack(p_150434_, p_150431_);
                                        while (!itemstack9.isEmpty() && ItemStack.isSame(slot6.getItem(), itemstack9)) {
                                            itemstack9 = this.quickMoveStack(p_150434_, p_150431_);
                                        }
                                    } else {
                                        if (p_150431_ < 0) {
                                            return;
                                        }
                                        Slot slot7 = this.slots.get(p_150431_);
                                        ItemStack itemstack10 = slot7.getItem();
                                        ItemStack itemstack11 = this.getCarried();
                                        p_150434_.updateTutorialInventoryAction(itemstack11, slot7.getItem(), clickaction);
                                        if (!itemstack11.overrideStackedOnOther(slot7, clickaction, p_150434_) && !itemstack10.overrideOtherStackedOnMe(itemstack11, slot7, clickaction, p_150434_, this.createCarriedSlotAccess())) {
                                            if (itemstack10.isEmpty()) {
                                                if (!itemstack11.isEmpty()) {
                                                    int l2 = clickaction == ClickAction.PRIMARY ? itemstack11.getCount() : 1;
                                                    this.setCarried(slot7.safeInsert(itemstack11, l2));
                                                }
                                            } else if (slot7.mayPickup(p_150434_)) {
                                                if (itemstack11.isEmpty()) {
                                                    int i3 = clickaction == ClickAction.PRIMARY ? itemstack10.getCount() : (itemstack10.getCount() + 1) / 2;
                                                    Optional<ItemStack> optional1 = slot7.tryRemove(i3, Integer.MAX_VALUE, p_150434_);
                                                    optional1.ifPresent(p_150421_ -> {
                                                        this.setCarried((ItemStack)p_150421_);
                                                        slot7.onTake(p_150434_, (ItemStack)p_150421_);
                                                    });
                                                } else if (slot7.mayPlace(itemstack11)) {
                                                    if (ItemStack.isSameItemSameTags(itemstack10, itemstack11)) {
                                                        int j3 = clickaction == ClickAction.PRIMARY ? itemstack11.getCount() : 1;
                                                        this.setCarried(slot7.safeInsert(itemstack11, j3));
                                                    } else if (itemstack11.getCount() <= slot7.getMaxStackSize(itemstack11)) {
                                                        slot7.set(itemstack11);
                                                        this.setCarried(itemstack10);
                                                    }
                                                } else if (ItemStack.isSameItemSameTags(itemstack10, itemstack11)) {
                                                    Optional<ItemStack> optional = slot7.tryRemove(itemstack10.getCount(), itemstack11.getMaxStackSize() - itemstack11.getCount(), p_150434_);
                                                    optional.ifPresent(p_150428_ -> {
                                                        itemstack11.grow(p_150428_.getCount());
                                                        slot7.onTake(p_150434_, (ItemStack)p_150428_);
                                                    });
                                                }
                                            }
                                        }
                                        slot7.setChanged();
                                    }
                                    break block41;
                                }
                                if (p_150433_ != ClickType.SWAP) break block48;
                                slot2 = this.slots.get(p_150431_);
                                itemstack4 = inventory.getItem(p_150432_);
                                itemstack7 = slot2.getItem();
                                if (itemstack4.isEmpty() && itemstack7.isEmpty()) break block41;
                                if (!itemstack4.isEmpty()) break block49;
                                if (!slot2.mayPickup(p_150434_)) break block41;
                                inventory.setItem(p_150432_, itemstack7);
                                slot2.onSwapCraft(itemstack7.getCount());
                                slot2.set(ItemStack.EMPTY);
                                slot2.onTake(p_150434_, itemstack7);
                                break block41;
                            }
                            if (!itemstack7.isEmpty()) break block50;
                            if (!slot2.mayPlace(itemstack4)) break block41;
                            int l1 = slot2.getMaxStackSize(itemstack4);
                            if (itemstack4.getCount() > l1) {
                                slot2.set(itemstack4.split(l1));
                            } else {
                                inventory.setItem(p_150432_, ItemStack.EMPTY);
                                slot2.set(itemstack4);
                            }
                            break block41;
                        }
                        if (!slot2.mayPickup(p_150434_) || !slot2.mayPlace(itemstack4)) break block41;
                        int i2 = slot2.getMaxStackSize(itemstack4);
                        if (itemstack4.getCount() <= i2) break block51;
                        slot2.set(itemstack4.split(i2));
                        slot2.onTake(p_150434_, itemstack7);
                        if (inventory.add(itemstack7)) break block41;
                        p_150434_.drop(itemstack7, true);
                        break block41;
                    }
                    inventory.setItem(p_150432_, itemstack7);
                    slot2.set(itemstack4);
                    slot2.onTake(p_150434_, itemstack7);
                    break block41;
                }
                if (p_150433_ != ClickType.CLONE || !p_150434_.getAbilities().instabuild || !this.getCarried().isEmpty() || p_150431_ < 0) break block52;
                Slot slot5 = this.slots.get(p_150431_);
                if (!slot5.hasItem()) break block41;
                ItemStack itemstack6 = slot5.getItem().copy();
                itemstack6.setCount(itemstack6.getMaxStackSize());
                this.setCarried(itemstack6);
                break block41;
            }
            if (p_150433_ == ClickType.THROW && this.getCarried().isEmpty() && p_150431_ >= 0) {
                Slot slot4 = this.slots.get(p_150431_);
                int i1 = p_150432_ == 0 ? 1 : slot4.getItem().getCount();
                ItemStack itemstack8 = slot4.safeTake(i1, Integer.MAX_VALUE, p_150434_);
                p_150434_.drop(itemstack8, true);
            } else if (p_150433_ == ClickType.PICKUP_ALL && p_150431_ >= 0) {
                Slot slot3 = this.slots.get(p_150431_);
                ItemStack itemstack5 = this.getCarried();
                if (!(itemstack5.isEmpty() || slot3.hasItem() && slot3.mayPickup(p_150434_))) {
                    int k1 = p_150432_ == 0 ? 0 : this.slots.size() - 1;
                    int j2 = p_150432_ == 0 ? 1 : -1;
                    int k2 = 0;
                    while (k2 < 2) {
                        int k3 = k1;
                        while (k3 >= 0 && k3 < this.slots.size() && itemstack5.getCount() < itemstack5.getMaxStackSize()) {
                            Slot slot8 = this.slots.get(k3);
                            if (slot8.hasItem() && AbstractContainerMenu.canItemQuickReplace(slot8, itemstack5, true) && slot8.mayPickup(p_150434_) && this.canTakeItemForPickAll(itemstack5, slot8)) {
                                ItemStack itemstack12 = slot8.getItem();
                                if (k2 != 0 || itemstack12.getCount() != itemstack12.getMaxStackSize()) {
                                    ItemStack itemstack13 = slot8.safeTake(itemstack12.getCount(), itemstack5.getMaxStackSize() - itemstack5.getCount(), p_150434_);
                                    itemstack5.grow(itemstack13.getCount());
                                }
                            }
                            k3 += j2;
                        }
                        ++k2;
                    }
                }
            }
        }
    }

    private SlotAccess createCarriedSlotAccess() {
        return new SlotAccess(){

            @Override
            public ItemStack get() {
                return AbstractContainerMenu.this.getCarried();
            }

            @Override
            public boolean set(ItemStack p_150452_) {
                AbstractContainerMenu.this.setCarried(p_150452_);
                return true;
            }
        };
    }

    public boolean canTakeItemForPickAll(ItemStack pStack, Slot pSlot) {
        return true;
    }

    public void removed(Player pPlayer) {
        ItemStack itemstack;
        if (pPlayer instanceof ServerPlayer && !(itemstack = this.getCarried()).isEmpty()) {
            if (pPlayer.isAlive() && !((ServerPlayer)pPlayer).hasDisconnected()) {
                pPlayer.getInventory().placeItemBackInInventory(itemstack);
            } else {
                pPlayer.drop(itemstack, false);
            }
            this.setCarried(ItemStack.EMPTY);
        }
    }

    protected void clearContainer(Player p_150412_, Container p_150413_) {
        if (!p_150412_.isAlive() || p_150412_ instanceof ServerPlayer && ((ServerPlayer)p_150412_).hasDisconnected()) {
            int j = 0;
            while (j < p_150413_.getContainerSize()) {
                p_150412_.drop(p_150413_.removeItemNoUpdate(j), false);
                ++j;
            }
        } else {
            int i = 0;
            while (i < p_150413_.getContainerSize()) {
                Inventory inventory = p_150412_.getInventory();
                if (inventory.player instanceof ServerPlayer) {
                    inventory.placeItemBackInInventory(p_150413_.removeItemNoUpdate(i));
                }
                ++i;
            }
        }
    }

    public void slotsChanged(Container pInventory) {
        this.broadcastChanges();
    }

    public void setItem(int pSlotId, int pStateId, ItemStack pStack) {
        this.getSlot(pSlotId).set(pStack);
        this.stateId = pStateId;
    }

    public void initializeContents(int p_182411_, List<ItemStack> p_182412_, ItemStack p_182413_) {
        int i = 0;
        while (i < p_182412_.size()) {
            this.getSlot(i).set(p_182412_.get(i));
            ++i;
        }
        this.carried = p_182413_;
        this.stateId = p_182411_;
    }

    public void setData(int pId, int pData) {
        this.dataSlots.get(pId).set(pData);
    }

    public abstract boolean stillValid(Player var1);

    protected boolean moveItemStackTo(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        boolean flag = false;
        int i = pStartIndex;
        if (pReverseDirection) {
            i = pEndIndex - 1;
        }
        if (pStack.isStackable()) {
            while (!pStack.isEmpty()) {
                if (!pReverseDirection ? i >= pEndIndex : i < pStartIndex) break;
                Slot slot = this.slots.get(i);
                ItemStack itemstack = slot.getItem();
                if (!itemstack.isEmpty() && ItemStack.isSameItemSameTags(pStack, itemstack)) {
                    int j = itemstack.getCount() + pStack.getCount();
                    if (j <= pStack.getMaxStackSize()) {
                        pStack.setCount(0);
                        itemstack.setCount(j);
                        slot.setChanged();
                        flag = true;
                    } else if (itemstack.getCount() < pStack.getMaxStackSize()) {
                        pStack.shrink(pStack.getMaxStackSize() - itemstack.getCount());
                        itemstack.setCount(pStack.getMaxStackSize());
                        slot.setChanged();
                        flag = true;
                    }
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!pStack.isEmpty()) {
            i = pReverseDirection ? pEndIndex - 1 : pStartIndex;
            while (!(!pReverseDirection ? i >= pEndIndex : i < pStartIndex)) {
                Slot slot1 = this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(pStack)) {
                    if (pStack.getCount() > slot1.getMaxStackSize()) {
                        slot1.set(pStack.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.set(pStack.split(pStack.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (pReverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public static int getQuickcraftType(int pEventButton) {
        return pEventButton >> 2 & 3;
    }

    public static int getQuickcraftHeader(int pClickedButton) {
        return pClickedButton & 3;
    }

    public static int getQuickcraftMask(int p_38931_, int p_38932_) {
        return p_38931_ & 3 | (p_38932_ & 3) << 2;
    }

    public static boolean isValidQuickcraftType(int pDragMode, Player pPlayer) {
        if (pDragMode == 0) {
            return true;
        }
        if (pDragMode == 1) {
            return true;
        }
        return pDragMode == 2 && pPlayer.getAbilities().instabuild;
    }

    protected void resetQuickCraft() {
        this.quickcraftStatus = 0;
        this.quickcraftSlots.clear();
    }

    public static boolean canItemQuickReplace(@Nullable Slot pSlot, ItemStack pStack, boolean pStackSizeMatters) {
        boolean flag;
        boolean bl = flag = pSlot == null || !pSlot.hasItem();
        if (!flag && ItemStack.isSameItemSameTags(pStack, pSlot.getItem())) {
            return pSlot.getItem().getCount() + (pStackSizeMatters ? 0 : pStack.getCount()) <= pStack.getMaxStackSize();
        }
        return flag;
    }

    public static void getQuickCraftSlotCount(Set<Slot> pDragSlots, int pDragMode, ItemStack pStack, int pSlotStackSize) {
        switch (pDragMode) {
            case 0: {
                pStack.setCount(Mth.floor((float)pStack.getCount() / (float)pDragSlots.size()));
                break;
            }
            case 1: {
                pStack.setCount(1);
                break;
            }
            case 2: {
                pStack.setCount(pStack.getItem().getMaxStackSize());
            }
        }
        pStack.grow(pSlotStackSize);
    }

    public boolean canDragTo(Slot pSlot) {
        return true;
    }

    public static int getRedstoneSignalFromBlockEntity(@Nullable BlockEntity pTe) {
        return pTe instanceof Container ? AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Object)pTe)) : 0;
    }

    public static int getRedstoneSignalFromContainer(@Nullable Container pInv) {
        if (pInv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        int j = 0;
        while (j < pInv.getContainerSize()) {
            ItemStack itemstack = pInv.getItem(j);
            if (!itemstack.isEmpty()) {
                f += (float)itemstack.getCount() / (float)Math.min(pInv.getMaxStackSize(), itemstack.getMaxStackSize());
                ++i;
            }
            ++j;
        }
        return Mth.floor((f /= (float)pInv.getContainerSize()) * 14.0f) + (i > 0 ? 1 : 0);
    }

    public void setCarried(ItemStack pStack) {
        this.carried = pStack;
    }

    public ItemStack getCarried() {
        return this.carried;
    }

    public void suppressRemoteUpdates() {
        this.suppressRemoteUpdates = true;
    }

    public void resumeRemoteUpdates() {
        this.suppressRemoteUpdates = false;
    }

    public void transferState(AbstractContainerMenu p_150415_) {
        HashBasedTable table = HashBasedTable.create();
        int i = 0;
        while (i < p_150415_.slots.size()) {
            Slot slot = p_150415_.slots.get(i);
            table.put((Object)slot.container, (Object)slot.getContainerSlot(), (Object)i);
            ++i;
        }
        int j = 0;
        while (j < this.slots.size()) {
            Slot slot1 = this.slots.get(j);
            Integer integer = (Integer)table.get((Object)slot1.container, (Object)slot1.getContainerSlot());
            if (integer != null) {
                this.lastSlots.set(j, p_150415_.lastSlots.get(integer));
                this.remoteSlots.set(j, p_150415_.remoteSlots.get(integer));
            }
            ++j;
        }
    }

    public OptionalInt findSlot(Container p_182418_, int p_182419_) {
        int i = 0;
        while (i < this.slots.size()) {
            Slot slot = this.slots.get(i);
            if (slot.container == p_182418_ && p_182419_ == slot.getContainerSlot()) {
                return OptionalInt.of(i);
            }
            ++i;
        }
        return OptionalInt.empty();
    }

    public int getStateId() {
        return this.stateId;
    }

    public int incrementStateId() {
        this.stateId = this.stateId + 1 & Short.MAX_VALUE;
        return this.stateId;
    }
}

