/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class BeaconMenu
extends AbstractContainerMenu {
    private static final int PAYMENT_SLOT = 0;
    private static final int SLOT_COUNT = 1;
    private static final int DATA_COUNT = 3;
    private static final int INV_SLOT_START = 1;
    private static final int INV_SLOT_END = 28;
    private static final int USE_ROW_SLOT_START = 28;
    private static final int USE_ROW_SLOT_END = 37;
    private final Container beacon = new SimpleContainer(1){

        @Override
        public boolean canPlaceItem(int p_39066_, ItemStack p_39067_) {
            return p_39067_.is(ItemTags.BEACON_PAYMENT_ITEMS);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }
    };
    private final PaymentSlot paymentSlot;
    private final ContainerLevelAccess access;
    private final ContainerData beaconData;

    public BeaconMenu(int p_39036_, Container p_39037_) {
        this(p_39036_, p_39037_, new SimpleContainerData(3), ContainerLevelAccess.NULL);
    }

    public BeaconMenu(int p_39039_, Container p_39040_, ContainerData p_39041_, ContainerLevelAccess p_39042_) {
        super(MenuType.BEACON, p_39039_);
        BeaconMenu.checkContainerDataCount(p_39041_, 3);
        this.beaconData = p_39041_;
        this.access = p_39042_;
        this.paymentSlot = new PaymentSlot(this.beacon, 0, 136, 110);
        this.addSlot(this.paymentSlot);
        this.addDataSlots(p_39041_);
        int i = 36;
        int j = 137;
        int k = 0;
        while (k < 3) {
            int l = 0;
            while (l < 9) {
                this.addSlot(new Slot(p_39040_, l + k * 9 + 9, 36 + l * 18, 137 + k * 18));
                ++l;
            }
            ++k;
        }
        int i1 = 0;
        while (i1 < 9) {
            this.addSlot(new Slot(p_39040_, i1, 36 + i1 * 18, 195));
            ++i1;
        }
    }

    @Override
    public void removed(Player pPlayer) {
        ItemStack itemstack;
        super.removed(pPlayer);
        if (!pPlayer.level.isClientSide && !(itemstack = this.paymentSlot.remove(this.paymentSlot.getMaxStackSize())).isEmpty()) {
            pPlayer.drop(itemstack, false);
        }
    }

    @Override
    public boolean stillValid(Player pPlayer) {
        return BeaconMenu.stillValid(this.access, pPlayer, Blocks.BEACON);
    }

    @Override
    public void setData(int pId, int pData) {
        super.setData(pId, pData);
        this.broadcastChanges();
    }

    @Override
    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex == 0) {
                if (!this.moveItemStackTo(itemstack1, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.paymentSlot.hasItem() && this.paymentSlot.mayPlace(itemstack1) && itemstack1.getCount() == 1 ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (pIndex >= 1 && pIndex < 28 ? !this.moveItemStackTo(itemstack1, 28, 37, false) : (pIndex >= 28 && pIndex < 37 ? !this.moveItemStackTo(itemstack1, 1, 28, false) : !this.moveItemStackTo(itemstack1, 1, 37, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public int getLevels() {
        return this.beaconData.get(0);
    }

    @Nullable
    public MobEffect getPrimaryEffect() {
        return MobEffect.byId(this.beaconData.get(1));
    }

    @Nullable
    public MobEffect getSecondaryEffect() {
        return MobEffect.byId(this.beaconData.get(2));
    }

    public void updateEffects(int p_39054_, int p_39055_) {
        if (this.paymentSlot.hasItem()) {
            this.beaconData.set(1, p_39054_);
            this.beaconData.set(2, p_39055_);
            this.paymentSlot.remove(1);
            this.access.execute(Level::blockEntityChanged);
        }
    }

    public boolean hasPayment() {
        return !this.beacon.getItem(0).isEmpty();
    }

    class PaymentSlot
    extends Slot {
        public PaymentSlot(Container p_39071_, int p_39072_, int p_39073_, int p_39074_) {
            super(p_39071_, p_39072_, p_39073_, p_39074_);
        }

        @Override
        public boolean mayPlace(ItemStack pStack) {
            return pStack.is(ItemTags.BEACON_PAYMENT_ITEMS);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }
    }
}

