/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class CartographyTableMenu
extends AbstractContainerMenu {
    public static final int MAP_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final ContainerLevelAccess access;
    long lastSoundTime;
    public final Container container = new SimpleContainer(2){

        @Override
        public void setChanged() {
            CartographyTableMenu.this.slotsChanged(this);
            super.setChanged();
        }
    };
    private final ResultContainer resultContainer = new ResultContainer(){

        @Override
        public void setChanged() {
            CartographyTableMenu.this.slotsChanged(this);
            super.setChanged();
        }
    };

    public CartographyTableMenu(int p_39140_, Inventory p_39141_) {
        this(p_39140_, p_39141_, ContainerLevelAccess.NULL);
    }

    public CartographyTableMenu(int p_39143_, Inventory p_39144_, ContainerLevelAccess p_39145_) {
        super(MenuType.CARTOGRAPHY_TABLE, p_39143_);
        this.access = p_39145_;
        this.addSlot(new Slot(this.container, 0, 15, 15){

            @Override
            public boolean mayPlace(ItemStack p_39194_) {
                return p_39194_.is(Items.FILLED_MAP);
            }
        });
        this.addSlot(new Slot(this.container, 1, 15, 52){

            @Override
            public boolean mayPlace(ItemStack p_39203_) {
                return p_39203_.is(Items.PAPER) || p_39203_.is(Items.MAP) || p_39203_.is(Items.GLASS_PANE);
            }
        });
        this.addSlot(new Slot(this.resultContainer, 2, 145, 39){

            @Override
            public boolean mayPlace(ItemStack p_39217_) {
                return false;
            }

            @Override
            public void onTake(Player p_150509_, ItemStack p_150510_) {
                ((Slot)CartographyTableMenu.this.slots.get(0)).remove(1);
                ((Slot)CartographyTableMenu.this.slots.get(1)).remove(1);
                p_150510_.getItem().onCraftedBy(p_150510_, p_150509_.level, p_150509_);
                p_39145_.execute((p_39219_, p_39220_) -> {
                    long l = p_39219_.getGameTime();
                    if (CartographyTableMenu.this.lastSoundTime != l) {
                        p_39219_.playSound(null, (BlockPos)p_39220_, SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        CartographyTableMenu.this.lastSoundTime = l;
                    }
                });
                super.onTake(p_150509_, p_150510_);
            }
        });
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 9) {
                this.addSlot(new Slot(p_39144_, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < 9) {
            this.addSlot(new Slot(p_39144_, k, 8 + k * 18, 142));
            ++k;
        }
    }

    @Override
    public boolean stillValid(Player pPlayer) {
        return CartographyTableMenu.stillValid(this.access, pPlayer, Blocks.CARTOGRAPHY_TABLE);
    }

    @Override
    public void slotsChanged(Container pInventory) {
        ItemStack itemstack = this.container.getItem(0);
        ItemStack itemstack1 = this.container.getItem(1);
        ItemStack itemstack2 = this.resultContainer.getItem(2);
        if (itemstack2.isEmpty() || !itemstack.isEmpty() && !itemstack1.isEmpty()) {
            if (!itemstack.isEmpty() && !itemstack1.isEmpty()) {
                this.setupResultSlot(itemstack, itemstack1, itemstack2);
            }
        } else {
            this.resultContainer.removeItemNoUpdate(2);
        }
    }

    private void setupResultSlot(ItemStack p_39163_, ItemStack p_39164_, ItemStack p_39165_) {
        this.access.execute((p_39170_, p_39171_) -> {
            MapItemSavedData mapitemsaveddata = MapItem.getSavedData(p_39163_, p_39170_);
            if (mapitemsaveddata != null) {
                ItemStack itemstack;
                if (p_39164_.is(Items.PAPER) && !mapitemsaveddata.locked && mapitemsaveddata.scale < 4) {
                    itemstack = p_39163_.copy();
                    itemstack.setCount(1);
                    itemstack.getOrCreateTag().putInt("map_scale_direction", 1);
                    this.broadcastChanges();
                } else if (p_39164_.is(Items.GLASS_PANE) && !mapitemsaveddata.locked) {
                    itemstack = p_39163_.copy();
                    itemstack.setCount(1);
                    itemstack.getOrCreateTag().putBoolean("map_to_lock", true);
                    this.broadcastChanges();
                } else {
                    if (!p_39164_.is(Items.MAP)) {
                        this.resultContainer.removeItemNoUpdate(2);
                        this.broadcastChanges();
                        return;
                    }
                    itemstack = p_39163_.copy();
                    itemstack.setCount(2);
                    this.broadcastChanges();
                }
                if (!ItemStack.matches(itemstack, p_39165_)) {
                    this.resultContainer.setItem(2, itemstack);
                    this.broadcastChanges();
                }
            }
        });
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack pStack, Slot pSlot) {
        return pSlot.container != this.resultContainer && super.canTakeItemForPickAll(pStack, pSlot);
    }

    @Override
    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex == 2) {
                itemstack1.getItem().onCraftedBy(itemstack1, pPlayer.level, pPlayer);
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (pIndex != 1 && pIndex != 0 ? (itemstack1.is(Items.FILLED_MAP) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (!itemstack1.is(Items.PAPER) && !itemstack1.is(Items.MAP) && !itemstack1.is(Items.GLASS_PANE) ? (pIndex >= 3 && pIndex < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : pIndex >= 30 && pIndex < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false)) : !this.moveItemStackTo(itemstack1, 1, 2, false))) : !this.moveItemStackTo(itemstack1, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    @Override
    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.resultContainer.removeItemNoUpdate(2);
        this.access.execute((p_39152_, p_39153_) -> this.clearContainer(pPlayer, this.container));
    }
}

