/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public interface ContainerLevelAccess {
    public static final ContainerLevelAccess NULL = new ContainerLevelAccess(){

        @Override
        public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> p_39304_) {
            return Optional.empty();
        }
    };

    public static ContainerLevelAccess create(Level pLevel, BlockPos pPos) {
        return new ContainerLevelAccess(){

            @Override
            public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> p_39311_) {
                return Optional.of(p_39311_.apply(pLevel, pPos));
            }
        };
    }

    public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> var1);

    default public <T> T evaluate(BiFunction<Level, BlockPos, T> pLevelPosConsumer, T pDefaultValue) {
        return this.evaluate(pLevelPosConsumer).orElse(pDefaultValue);
    }

    default public void execute(BiConsumer<Level, BlockPos> pLevelPosConsumer) {
        this.evaluate((p_39296_, p_39297_) -> {
            pLevelPosConsumer.accept((Level)p_39296_, (BlockPos)p_39297_);
            return Optional.empty();
        });
    }
}

