/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnchantmentTableBlock;

public class EnchantmentMenu
extends AbstractContainerMenu {
    private final Container enchantSlots = new SimpleContainer(2){

        @Override
        public void setChanged() {
            super.setChanged();
            EnchantmentMenu.this.slotsChanged(this);
        }
    };
    private final ContainerLevelAccess access;
    private final Random random = new Random();
    private final DataSlot enchantmentSeed = DataSlot.standalone();
    public final int[] costs = new int[3];
    public final int[] enchantClue = new int[]{-1, -1, -1};
    public final int[] levelClue = new int[]{-1, -1, -1};

    public EnchantmentMenu(int p_39454_, Inventory p_39455_) {
        this(p_39454_, p_39455_, ContainerLevelAccess.NULL);
    }

    public EnchantmentMenu(int p_39457_, Inventory p_39458_, ContainerLevelAccess p_39459_) {
        super(MenuType.ENCHANTMENT, p_39457_);
        this.access = p_39459_;
        this.addSlot(new Slot(this.enchantSlots, 0, 15, 47){

            @Override
            public boolean mayPlace(ItemStack p_39508_) {
                return true;
            }

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        });
        this.addSlot(new Slot(this.enchantSlots, 1, 35, 47){

            @Override
            public boolean mayPlace(ItemStack p_39517_) {
                return p_39517_.is(Items.LAPIS_LAZULI);
            }
        });
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 9) {
                this.addSlot(new Slot(p_39458_, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < 9) {
            this.addSlot(new Slot(p_39458_, k, 8 + k * 18, 142));
            ++k;
        }
        this.addDataSlot(DataSlot.a(this.costs, 0));
        this.addDataSlot(DataSlot.a(this.costs, 1));
        this.addDataSlot(DataSlot.a(this.costs, 2));
        this.addDataSlot(this.enchantmentSeed).set(p_39458_.player.getEnchantmentSeed());
        this.addDataSlot(DataSlot.a(this.enchantClue, 0));
        this.addDataSlot(DataSlot.a(this.enchantClue, 1));
        this.addDataSlot(DataSlot.a(this.enchantClue, 2));
        this.addDataSlot(DataSlot.a(this.levelClue, 0));
        this.addDataSlot(DataSlot.a(this.levelClue, 1));
        this.addDataSlot(DataSlot.a(this.levelClue, 2));
    }

    @Override
    public void slotsChanged(Container pInventory) {
        if (pInventory == this.enchantSlots) {
            ItemStack itemstack = pInventory.getItem(0);
            if (!itemstack.isEmpty() && itemstack.isEnchantable()) {
                this.access.execute((p_39485_, p_39486_) -> {
                    int j = 0;
                    for (BlockPos blockpos : EnchantmentTableBlock.BOOKSHELF_OFFSETS) {
                        if (!EnchantmentTableBlock.isValidBookShelf(p_39485_, p_39486_, blockpos)) continue;
                        ++j;
                    }
                    this.random.setSeed(this.enchantmentSeed.get());
                    int k = 0;
                    while (k < 3) {
                        this.costs[k] = EnchantmentHelper.getEnchantmentCost(this.random, k, j, itemstack);
                        this.enchantClue[k] = -1;
                        this.levelClue[k] = -1;
                        if (this.costs[k] < k + 1) {
                            this.costs[k] = 0;
                        }
                        ++k;
                    }
                    int l = 0;
                    while (l < 3) {
                        List<EnchantmentInstance> list;
                        if (this.costs[l] > 0 && (list = this.getEnchantmentList(itemstack, l, this.costs[l])) != null && !list.isEmpty()) {
                            EnchantmentInstance enchantmentinstance = list.get(this.random.nextInt(list.size()));
                            this.enchantClue[l] = Registry.ENCHANTMENT.getId(enchantmentinstance.enchantment);
                            this.levelClue[l] = enchantmentinstance.level;
                        }
                        ++l;
                    }
                    this.broadcastChanges();
                });
            } else {
                int i = 0;
                while (i < 3) {
                    this.costs[i] = 0;
                    this.enchantClue[i] = -1;
                    this.levelClue[i] = -1;
                    ++i;
                }
            }
        }
    }

    @Override
    public boolean clickMenuButton(Player pPlayer, int pId) {
        if (pId >= 0 && pId < this.costs.length) {
            ItemStack itemstack = this.enchantSlots.getItem(0);
            ItemStack itemstack1 = this.enchantSlots.getItem(1);
            int i = pId + 1;
            if ((itemstack1.isEmpty() || itemstack1.getCount() < i) && !pPlayer.getAbilities().instabuild) {
                return false;
            }
            if (this.costs[pId] <= 0 || itemstack.isEmpty() || (pPlayer.experienceLevel < i || pPlayer.experienceLevel < this.costs[pId]) && !pPlayer.getAbilities().instabuild) {
                return false;
            }
            this.access.execute((p_39481_, p_39482_) -> {
                ItemStack itemstack2 = itemstack;
                List<EnchantmentInstance> list = this.getEnchantmentList(itemstack, pId, this.costs[pId]);
                if (!list.isEmpty()) {
                    pPlayer.onEnchantmentPerformed(itemstack, i);
                    boolean flag = itemstack.is(Items.BOOK);
                    if (flag) {
                        itemstack2 = new ItemStack(Items.ENCHANTED_BOOK);
                        CompoundTag compoundtag = itemstack.getTag();
                        if (compoundtag != null) {
                            itemstack2.setTag(compoundtag.copy());
                        }
                        this.enchantSlots.setItem(0, itemstack2);
                    }
                    int j = 0;
                    while (j < list.size()) {
                        EnchantmentInstance enchantmentinstance = list.get(j);
                        if (flag) {
                            EnchantedBookItem.addEnchantment(itemstack2, enchantmentinstance);
                        } else {
                            itemstack2.enchant(enchantmentinstance.enchantment, enchantmentinstance.level);
                        }
                        ++j;
                    }
                    if (!player.getAbilities().instabuild) {
                        itemstack1.shrink(i);
                        if (itemstack1.isEmpty()) {
                            this.enchantSlots.setItem(1, ItemStack.EMPTY);
                        }
                    }
                    pPlayer.awardStat(Stats.ENCHANT_ITEM);
                    if (pPlayer instanceof ServerPlayer) {
                        CriteriaTriggers.ENCHANTED_ITEM.trigger((ServerPlayer)pPlayer, itemstack2, i);
                    }
                    this.enchantSlots.setChanged();
                    this.enchantmentSeed.set(pPlayer.getEnchantmentSeed());
                    this.slotsChanged(this.enchantSlots);
                    p_39481_.playSound(null, (BlockPos)p_39482_, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, p_39481_.random.nextFloat() * 0.1f + 0.9f);
                }
            });
            return true;
        }
        Util.logAndPauseIfInIde(pPlayer.getName() + " pressed invalid button id: " + pId);
        return false;
    }

    private List<EnchantmentInstance> getEnchantmentList(ItemStack pStack, int pEnchantSlot, int pLevel) {
        this.random.setSeed(this.enchantmentSeed.get() + pEnchantSlot);
        List<EnchantmentInstance> list = EnchantmentHelper.selectEnchantment(this.random, pStack, pLevel, false);
        if (pStack.is(Items.BOOK) && list.size() > 1) {
            list.remove(this.random.nextInt(list.size()));
        }
        return list;
    }

    public int getGoldCount() {
        ItemStack itemstack = this.enchantSlots.getItem(1);
        return itemstack.isEmpty() ? 0 : itemstack.getCount();
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed.get();
    }

    @Override
    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.access.execute((p_39469_, p_39470_) -> this.clearContainer(pPlayer, this.enchantSlots));
    }

    @Override
    public boolean stillValid(Player pPlayer) {
        return EnchantmentMenu.stillValid(this.access, pPlayer, Blocks.ENCHANTING_TABLE);
    }

    @Override
    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex == 0) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (pIndex == 1) {
                if (!this.moveItemStackTo(itemstack1, 2, 38, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (itemstack1.is(Items.LAPIS_LAZULI)) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (((Slot)this.slots.get(0)).hasItem() || !((Slot)this.slots.get(0)).mayPlace(itemstack1)) {
                    return ItemStack.EMPTY;
                }
                ItemStack itemstack2 = itemstack1.copy();
                itemstack2.setCount(1);
                itemstack1.shrink(1);
                ((Slot)this.slots.get(0)).set(itemstack2);
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
        }
        return itemstack;
    }
}

