/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class HopperMenu
extends AbstractContainerMenu {
    public static final int CONTAINER_SIZE = 5;
    private final Container hopper;

    public HopperMenu(int p_39640_, Inventory p_39641_) {
        this(p_39640_, p_39641_, new SimpleContainer(5));
    }

    public HopperMenu(int p_39643_, Inventory p_39644_, Container p_39645_) {
        super(MenuType.HOPPER, p_39643_);
        this.hopper = p_39645_;
        HopperMenu.checkContainerSize(p_39645_, 5);
        p_39645_.startOpen(p_39644_.player);
        int i = 51;
        int j = 0;
        while (j < 5) {
            this.addSlot(new Slot(p_39645_, j, 44 + j * 18, 20));
            ++j;
        }
        int l = 0;
        while (l < 3) {
            int k = 0;
            while (k < 9) {
                this.addSlot(new Slot(p_39644_, k + l * 9 + 9, 8 + k * 18, l * 18 + 51));
                ++k;
            }
            ++l;
        }
        int i1 = 0;
        while (i1 < 9) {
            this.addSlot(new Slot(p_39644_, i1, 8 + i1 * 18, 109));
            ++i1;
        }
    }

    @Override
    public boolean stillValid(Player pPlayer) {
        return this.hopper.stillValid(pPlayer);
    }

    @Override
    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex < this.hopper.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.hopper.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.hopper.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.hopper.stopOpen(pPlayer);
    }
}

