/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class LoomMenu
extends AbstractContainerMenu {
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;
    private final ContainerLevelAccess access;
    final DataSlot selectedBannerPatternIndex = DataSlot.standalone();
    Runnable slotUpdateListener = () -> {};
    final Slot bannerSlot;
    final Slot dyeSlot;
    private final Slot patternSlot;
    private final Slot resultSlot;
    long lastSoundTime;
    private final Container inputContainer = new SimpleContainer(3){

        @Override
        public void setChanged() {
            super.setChanged();
            LoomMenu.this.slotsChanged(this);
            LoomMenu.this.slotUpdateListener.run();
        }
    };
    private final Container outputContainer = new SimpleContainer(1){

        @Override
        public void setChanged() {
            super.setChanged();
            LoomMenu.this.slotUpdateListener.run();
        }
    };

    public LoomMenu(int p_39856_, Inventory p_39857_) {
        this(p_39856_, p_39857_, ContainerLevelAccess.NULL);
    }

    public LoomMenu(int p_39859_, Inventory p_39860_, ContainerLevelAccess p_39861_) {
        super(MenuType.LOOM, p_39859_);
        this.access = p_39861_;
        this.bannerSlot = this.addSlot(new Slot(this.inputContainer, 0, 13, 26){

            @Override
            public boolean mayPlace(ItemStack p_39918_) {
                return p_39918_.getItem() instanceof BannerItem;
            }
        });
        this.dyeSlot = this.addSlot(new Slot(this.inputContainer, 1, 33, 26){

            @Override
            public boolean mayPlace(ItemStack p_39927_) {
                return p_39927_.getItem() instanceof DyeItem;
            }
        });
        this.patternSlot = this.addSlot(new Slot(this.inputContainer, 2, 23, 45){

            @Override
            public boolean mayPlace(ItemStack p_39936_) {
                return p_39936_.getItem() instanceof BannerPatternItem;
            }
        });
        this.resultSlot = this.addSlot(new Slot(this.outputContainer, 0, 143, 58){

            @Override
            public boolean mayPlace(ItemStack p_39950_) {
                return false;
            }

            @Override
            public void onTake(Player p_150617_, ItemStack p_150618_) {
                LoomMenu.this.bannerSlot.remove(1);
                LoomMenu.this.dyeSlot.remove(1);
                if (!LoomMenu.this.bannerSlot.hasItem() || !LoomMenu.this.dyeSlot.hasItem()) {
                    LoomMenu.this.selectedBannerPatternIndex.set(0);
                }
                p_39861_.execute((p_39952_, p_39953_) -> {
                    long l = p_39952_.getGameTime();
                    if (LoomMenu.this.lastSoundTime != l) {
                        p_39952_.playSound(null, (BlockPos)p_39953_, SoundEvents.UI_LOOM_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        LoomMenu.this.lastSoundTime = l;
                    }
                });
                super.onTake(p_150617_, p_150618_);
            }
        });
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 9) {
                this.addSlot(new Slot(p_39860_, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < 9) {
            this.addSlot(new Slot(p_39860_, k, 8 + k * 18, 142));
            ++k;
        }
        this.addDataSlot(this.selectedBannerPatternIndex);
    }

    public int getSelectedBannerPatternIndex() {
        return this.selectedBannerPatternIndex.get();
    }

    @Override
    public boolean stillValid(Player pPlayer) {
        return LoomMenu.stillValid(this.access, pPlayer, Blocks.LOOM);
    }

    @Override
    public boolean clickMenuButton(Player pPlayer, int pId) {
        if (pId > 0 && pId <= BannerPattern.AVAILABLE_PATTERNS) {
            this.selectedBannerPatternIndex.set(pId);
            this.setupResultSlot();
            return true;
        }
        return false;
    }

    @Override
    public void slotsChanged(Container pInventory) {
        ItemStack itemstack = this.bannerSlot.getItem();
        ItemStack itemstack1 = this.dyeSlot.getItem();
        ItemStack itemstack2 = this.patternSlot.getItem();
        ItemStack itemstack3 = this.resultSlot.getItem();
        if (itemstack3.isEmpty() || !itemstack.isEmpty() && !itemstack1.isEmpty() && this.selectedBannerPatternIndex.get() > 0 && (this.selectedBannerPatternIndex.get() < BannerPattern.COUNT - BannerPattern.PATTERN_ITEM_COUNT || !itemstack2.isEmpty())) {
            if (!itemstack2.isEmpty() && itemstack2.getItem() instanceof BannerPatternItem) {
                boolean flag;
                CompoundTag compoundtag = BlockItem.getBlockEntityData(itemstack);
                boolean bl = flag = compoundtag != null && compoundtag.contains("Patterns", 9) && !itemstack.isEmpty() && compoundtag.getList("Patterns", 10).size() >= 6;
                if (flag) {
                    this.selectedBannerPatternIndex.set(0);
                } else {
                    this.selectedBannerPatternIndex.set(((BannerPatternItem)itemstack2.getItem()).getBannerPattern().ordinal());
                }
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
            this.selectedBannerPatternIndex.set(0);
        }
        this.setupResultSlot();
        this.broadcastChanges();
    }

    public void registerUpdateListener(Runnable p_39879_) {
        this.slotUpdateListener = p_39879_;
    }

    @Override
    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex == this.resultSlot.index) {
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (pIndex != this.dyeSlot.index && pIndex != this.bannerSlot.index && pIndex != this.patternSlot.index ? (itemstack1.getItem() instanceof BannerItem ? !this.moveItemStackTo(itemstack1, this.bannerSlot.index, this.bannerSlot.index + 1, false) : (itemstack1.getItem() instanceof DyeItem ? !this.moveItemStackTo(itemstack1, this.dyeSlot.index, this.dyeSlot.index + 1, false) : (itemstack1.getItem() instanceof BannerPatternItem ? !this.moveItemStackTo(itemstack1, this.patternSlot.index, this.patternSlot.index + 1, false) : (pIndex >= 4 && pIndex < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : pIndex >= 31 && pIndex < 40 && !this.moveItemStackTo(itemstack1, 4, 31, false))))) : !this.moveItemStackTo(itemstack1, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, itemstack1);
        }
        return itemstack;
    }

    @Override
    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.access.execute((p_39871_, p_39872_) -> this.clearContainer(pPlayer, this.inputContainer));
    }

    private void setupResultSlot() {
        if (this.selectedBannerPatternIndex.get() > 0) {
            ItemStack itemstack = this.bannerSlot.getItem();
            ItemStack itemstack1 = this.dyeSlot.getItem();
            ItemStack itemstack2 = ItemStack.EMPTY;
            if (!itemstack.isEmpty() && !itemstack1.isEmpty()) {
                ListTag listtag;
                itemstack2 = itemstack.copy();
                itemstack2.setCount(1);
                BannerPattern bannerpattern = BannerPattern.values()[this.selectedBannerPatternIndex.get()];
                DyeColor dyecolor = ((DyeItem)itemstack1.getItem()).getDyeColor();
                CompoundTag compoundtag = BlockItem.getBlockEntityData(itemstack2);
                if (compoundtag != null && compoundtag.contains("Patterns", 9)) {
                    listtag = compoundtag.getList("Patterns", 10);
                } else {
                    listtag = new ListTag();
                    if (compoundtag == null) {
                        compoundtag = new CompoundTag();
                    }
                    compoundtag.put("Patterns", listtag);
                }
                CompoundTag compoundtag1 = new CompoundTag();
                compoundtag1.putString("Pattern", bannerpattern.getHashname());
                compoundtag1.putInt("Color", dyecolor.getId());
                listtag.add(compoundtag1);
                BlockItem.setBlockEntityData(itemstack2, BlockEntityType.BANNER, compoundtag);
            }
            if (!ItemStack.matches(itemstack2, this.resultSlot.getItem())) {
                this.resultSlot.set(itemstack2);
            }
        }
    }

    public Slot getBannerSlot() {
        return this.bannerSlot;
    }

    public Slot getDyeSlot() {
        return this.dyeSlot;
    }

    public Slot getPatternSlot() {
        return this.patternSlot;
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }
}

