/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;

public class PlayerEnderChestContainer
extends SimpleContainer {
    @Nullable
    private EnderChestBlockEntity activeChest;

    public PlayerEnderChestContainer() {
        super(27);
    }

    public void setActiveChest(EnderChestBlockEntity pChestBlockEntity) {
        this.activeChest = pChestBlockEntity;
    }

    public boolean isActiveChest(EnderChestBlockEntity p_150634_) {
        return this.activeChest == p_150634_;
    }

    @Override
    public void fromTag(ListTag pContainerNbt) {
        int i = 0;
        while (i < this.getContainerSize()) {
            this.setItem(i, ItemStack.EMPTY);
            ++i;
        }
        int k = 0;
        while (k < pContainerNbt.size()) {
            CompoundTag compoundtag = pContainerNbt.getCompound(k);
            int j = compoundtag.getByte("Slot") & 0xFF;
            if (j >= 0 && j < this.getContainerSize()) {
                this.setItem(j, ItemStack.of(compoundtag));
            }
            ++k;
        }
    }

    @Override
    public ListTag createTag() {
        ListTag listtag = new ListTag();
        int i = 0;
        while (i < this.getContainerSize()) {
            ItemStack itemstack = this.getItem(i);
            if (!itemstack.isEmpty()) {
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.putByte("Slot", (byte)i);
                itemstack.save(compoundtag);
                listtag.add(compoundtag);
            }
            ++i;
        }
        return listtag;
    }

    @Override
    public boolean stillValid(Player pPlayer) {
        return this.activeChest != null && !this.activeChest.stillValid(pPlayer) ? false : super.stillValid(pPlayer);
    }

    @Override
    public void startOpen(Player pPlayer) {
        if (this.activeChest != null) {
            this.activeChest.startOpen(pPlayer);
        }
        super.startOpen(pPlayer);
    }

    @Override
    public void stopOpen(Player pPlayer) {
        if (this.activeChest != null) {
            this.activeChest.stopOpen(pPlayer);
        }
        super.stopOpen(pPlayer);
        this.activeChest = null;
    }
}

