/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public interface RecipeHolder {
    public void setRecipeUsed(@Nullable Recipe<?> var1);

    @Nullable
    public Recipe<?> getRecipeUsed();

    default public void awardUsedRecipes(Player pPlayer) {
        Recipe<?> recipe = this.getRecipeUsed();
        if (recipe != null && !recipe.isSpecial()) {
            pPlayer.awardRecipes(Collections.singleton(recipe));
            this.setRecipeUsed(null);
        }
    }

    default public boolean setRecipeUsed(Level pLevel, ServerPlayer pPlayer, Recipe<?> pRecipe) {
        if (!pRecipe.isSpecial() && pLevel.getGameRules().getBoolean(GameRules.RULE_LIMITED_CRAFTING) && !pPlayer.getRecipeBook().contains(pRecipe)) {
            return false;
        }
        this.setRecipeUsed(pRecipe);
        return true;
    }
}

