/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ShulkerBoxSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ShulkerBoxMenu
extends AbstractContainerMenu {
    private static final int CONTAINER_SIZE = 27;
    private final Container container;

    public ShulkerBoxMenu(int p_40188_, Inventory p_40189_) {
        this(p_40188_, p_40189_, new SimpleContainer(27));
    }

    public ShulkerBoxMenu(int p_40191_, Inventory p_40192_, Container p_40193_) {
        super(MenuType.SHULKER_BOX, p_40191_);
        ShulkerBoxMenu.checkContainerSize(p_40193_, 27);
        this.container = p_40193_;
        p_40193_.startOpen(p_40192_.player);
        int i = 3;
        int j = 9;
        int k = 0;
        while (k < 3) {
            int l = 0;
            while (l < 9) {
                this.addSlot(new ShulkerBoxSlot(p_40193_, l + k * 9, 8 + l * 18, 18 + k * 18));
                ++l;
            }
            ++k;
        }
        int i1 = 0;
        while (i1 < 3) {
            int k1 = 0;
            while (k1 < 9) {
                this.addSlot(new Slot(p_40192_, k1 + i1 * 9 + 9, 8 + k1 * 18, 84 + i1 * 18));
                ++k1;
            }
            ++i1;
        }
        int j1 = 0;
        while (j1 < 9) {
            this.addSlot(new Slot(p_40192_, j1, 8 + j1 * 18, 142));
            ++j1;
        }
    }

    @Override
    public boolean stillValid(Player pPlayer) {
        return this.container.stillValid(pPlayer);
    }

    @Override
    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (pIndex < this.container.getContainerSize() ? !this.moveItemStackTo(itemstack1, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.container.stopOpen(pPlayer);
    }
}

