/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.apache.commons.lang3.Validate;

public class BannerItem
extends StandingAndWallBlockItem {
    private static final String PATTERN_PREFIX = "block.minecraft.banner.";

    public BannerItem(Block p_40534_, Block p_40535_, Item.Properties p_40536_) {
        super(p_40534_, p_40535_, p_40536_);
        Validate.isInstanceOf(AbstractBannerBlock.class, (Object)p_40534_);
        Validate.isInstanceOf(AbstractBannerBlock.class, (Object)p_40535_);
    }

    public static void appendHoverTextFromBannerBlockEntityTag(ItemStack pStack, List<Component> pTooltipComponents) {
        CompoundTag compoundtag = BlockItem.getBlockEntityData(pStack);
        if (compoundtag != null && compoundtag.contains("Patterns")) {
            ListTag listtag = compoundtag.getList("Patterns", 10);
            int i = 0;
            while (i < listtag.size() && i < 6) {
                CompoundTag compoundtag1 = listtag.getCompound(i);
                DyeColor dyecolor = DyeColor.byId(compoundtag1.getInt("Color"));
                BannerPattern bannerpattern = BannerPattern.byHash(compoundtag1.getString("Pattern"));
                if (bannerpattern != null) {
                    pTooltipComponents.add(new TranslatableComponent(PATTERN_PREFIX + bannerpattern.getFilename() + "." + dyecolor.getName()).withStyle(ChatFormatting.GRAY));
                }
                ++i;
            }
        }
    }

    public DyeColor getColor() {
        return ((AbstractBannerBlock)this.getBlock()).getColor();
    }

    @Override
    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        BannerItem.appendHoverTextFromBannerBlockEntityTag(pStack, pTooltip);
    }
}

