/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final Boat.Type type;

    public BoatItem(Boat.Type pType, Item.Properties pProperties) {
        super(pProperties);
        this.type = pType;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        BlockHitResult hitresult = BoatItem.getPlayerPOVHitResult(pLevel, pPlayer, ClipContext.Fluid.ANY);
        if (((HitResult)hitresult).getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass(itemstack);
        }
        Vec3 vec3 = pPlayer.getViewVector(1.0f);
        double d0 = 5.0;
        List<Entity> list = pLevel.getEntities(pPlayer, pPlayer.getBoundingBox().expandTowards(vec3.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = pPlayer.getEyePosition();
            for (Entity entity : list) {
                AABB aabb = entity.getBoundingBox().inflate(entity.getPickRadius());
                if (!aabb.contains(vec31)) continue;
                return InteractionResultHolder.pass(itemstack);
            }
        }
        if (((HitResult)hitresult).getType() == HitResult.Type.BLOCK) {
            Boat boat = new Boat(pLevel, hitresult.getLocation().x, hitresult.getLocation().y, hitresult.getLocation().z);
            boat.setType(this.type);
            boat.setYRot(pPlayer.getYRot());
            if (!pLevel.noCollision(boat, boat.getBoundingBox())) {
                return InteractionResultHolder.fail(itemstack);
            }
            if (!pLevel.isClientSide) {
                pLevel.addFreshEntity(boat);
                pLevel.gameEvent((Entity)pPlayer, GameEvent.ENTITY_PLACE, new BlockPos(hitresult.getLocation()));
                if (!pPlayer.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            pPlayer.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResultHolder.sidedSuccess(itemstack, pLevel.isClientSide());
        }
        return InteractionResultHolder.pass(itemstack);
    }
}

