/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BoneMealItem
extends Item {
    public static final int GRASS_SPREAD_WIDTH = 3;
    public static final int GRASS_SPREAD_HEIGHT = 1;
    public static final int GRASS_COUNT_MULTIPLIER = 3;

    public BoneMealItem(Item.Properties p_40626_) {
        super(p_40626_);
    }

    @Override
    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        BlockPos blockpos1 = blockpos.relative(pContext.getClickedFace());
        if (BoneMealItem.growCrop(pContext.getItemInHand(), level, blockpos)) {
            if (!level.isClientSide) {
                level.levelEvent(1505, blockpos, 0);
            }
            return InteractionResult.sidedSuccess(level.isClientSide);
        }
        BlockState blockstate = level.getBlockState(blockpos);
        boolean flag = blockstate.isFaceSturdy(level, blockpos, pContext.getClickedFace());
        if (flag && BoneMealItem.growWaterPlant(pContext.getItemInHand(), level, blockpos1, pContext.getClickedFace())) {
            if (!level.isClientSide) {
                level.levelEvent(1505, blockpos1, 0);
            }
            return InteractionResult.sidedSuccess(level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static boolean growCrop(ItemStack pStack, Level pLevel, BlockPos pPos) {
        BonemealableBlock bonemealableblock;
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (blockstate.getBlock() instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)((Object)blockstate.getBlock())).isValidBonemealTarget(pLevel, pPos, blockstate, pLevel.isClientSide)) {
            if (pLevel instanceof ServerLevel) {
                if (bonemealableblock.isBonemealSuccess(pLevel, pLevel.random, pPos, blockstate)) {
                    bonemealableblock.performBonemeal((ServerLevel)pLevel, pLevel.random, pPos, blockstate);
                }
                pStack.shrink(1);
            }
            return true;
        }
        return false;
    }

    public static boolean growWaterPlant(ItemStack pStack, Level pLevel, BlockPos pPos, @Nullable Direction pClickedSide) {
        if (pLevel.getBlockState(pPos).is(Blocks.WATER) && pLevel.getFluidState(pPos).getAmount() == 8) {
            if (!(pLevel instanceof ServerLevel)) {
                return true;
            }
            Random random = pLevel.getRandom();
            int i = 0;
            while (i < 128) {
                block16: {
                    BlockPos blockpos = pPos;
                    BlockState blockstate = Blocks.SEAGRASS.defaultBlockState();
                    int j = 0;
                    while (j < i / 16) {
                        if (!pLevel.getBlockState(blockpos = blockpos.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).isCollisionShapeFullBlock(pLevel, blockpos)) {
                            ++j;
                            continue;
                        }
                        break block16;
                    }
                    Holder<Biome> holder = pLevel.getBiome(blockpos);
                    if (holder.is(Biomes.WARM_OCEAN)) {
                        if (i == 0 && pClickedSide != null && pClickedSide.getAxis().isHorizontal()) {
                            blockstate = Registry.BLOCK.getTag(BlockTags.WALL_CORALS).flatMap(p_204098_ -> p_204098_.getRandomElement(level.random)).map(p_204100_ -> ((Block)p_204100_.value()).defaultBlockState()).orElse(blockstate);
                            if (blockstate.hasProperty(BaseCoralWallFanBlock.FACING)) {
                                blockstate = (BlockState)blockstate.setValue(BaseCoralWallFanBlock.FACING, pClickedSide);
                            }
                        } else if (random.nextInt(4) == 0) {
                            blockstate = Registry.BLOCK.getTag(BlockTags.UNDERWATER_BONEMEALS).flatMap(p_204091_ -> p_204091_.getRandomElement(level.random)).map(p_204095_ -> ((Block)p_204095_.value()).defaultBlockState()).orElse(blockstate);
                        }
                    }
                    if (blockstate.is(BlockTags.WALL_CORALS, p_204093_ -> p_204093_.hasProperty(BaseCoralWallFanBlock.FACING))) {
                        int k = 0;
                        while (!blockstate.canSurvive(pLevel, blockpos) && k < 4) {
                            blockstate = (BlockState)blockstate.setValue(BaseCoralWallFanBlock.FACING, Direction.Plane.HORIZONTAL.getRandomDirection(random));
                            ++k;
                        }
                    }
                    if (blockstate.canSurvive(pLevel, blockpos)) {
                        BlockState blockstate1 = pLevel.getBlockState(blockpos);
                        if (blockstate1.is(Blocks.WATER) && pLevel.getFluidState(blockpos).getAmount() == 8) {
                            pLevel.setBlock(blockpos, blockstate, 3);
                        } else if (blockstate1.is(Blocks.SEAGRASS) && random.nextInt(10) == 0) {
                            ((BonemealableBlock)((Object)Blocks.SEAGRASS)).performBonemeal((ServerLevel)pLevel, random, blockpos, blockstate1);
                        }
                    }
                }
                ++i;
            }
            pStack.shrink(1);
            return true;
        }
        return false;
    }

    public static void addGrowthParticles(LevelAccessor pLevel, BlockPos pPos, int pData) {
        BlockState blockstate;
        if (pData == 0) {
            pData = 15;
        }
        if (!(blockstate = pLevel.getBlockState(pPos)).isAir()) {
            double d1;
            double d0 = 0.5;
            if (blockstate.is(Blocks.WATER)) {
                pData *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.isSolidRender(pLevel, pPos)) {
                pPos = pPos.above();
                pData *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.getShape(pLevel, pPos).max(Direction.Axis.Y);
            }
            pLevel.addParticle(ParticleTypes.HAPPY_VILLAGER, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, 0.0, 0.0, 0.0);
            Random random = pLevel.getRandom();
            int i = 0;
            while (i < pData) {
                double d8;
                double d7;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextGaussian() * 0.02;
                double d4 = random.nextGaussian() * 0.02;
                double d5 = 0.5 - d0;
                double d6 = (double)pPos.getX() + d5 + random.nextDouble() * d0 * 2.0;
                if (!pLevel.getBlockState(new BlockPos(d6, d7 = (double)pPos.getY() + random.nextDouble() * d1, d8 = (double)pPos.getZ() + d5 + random.nextDouble() * d0 * 2.0).below()).isAir()) {
                    pLevel.addParticle(ParticleTypes.HAPPY_VILLAGER, d6, d7, d8, d2, d3, d4);
                }
                ++i;
            }
        }
    }
}

