/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BundleItem
extends Item {
    private static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 64;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int BAR_COLOR = Mth.color(0.4f, 0.4f, 1.0f);

    public BundleItem(Item.Properties p_150726_) {
        super(p_150726_);
    }

    public static float getFullnessDisplay(ItemStack pStack) {
        return (float)BundleItem.getContentWeight(pStack) / 64.0f;
    }

    @Override
    public boolean overrideStackedOnOther(ItemStack pStack, Slot pSlot, ClickAction pAction, Player pPlayer) {
        if (pAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = pSlot.getItem();
        if (itemstack.isEmpty()) {
            this.playRemoveOneSound(pPlayer);
            BundleItem.removeOne(pStack).ifPresent(p_150740_ -> BundleItem.add(pStack, pSlot.safeInsert((ItemStack)p_150740_)));
        } else if (itemstack.getItem().canFitInsideContainerItems()) {
            int i = (64 - BundleItem.getContentWeight(pStack)) / BundleItem.getWeight(itemstack);
            int j = BundleItem.add(pStack, pSlot.safeTake(itemstack.getCount(), i, pPlayer));
            if (j > 0) {
                this.playInsertSound(pPlayer);
            }
        }
        return true;
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pAction == ClickAction.SECONDARY && pSlot.allowModification(pPlayer)) {
            if (pOther.isEmpty()) {
                BundleItem.removeOne(pStack).ifPresent(p_186347_ -> {
                    this.playRemoveOneSound(pPlayer);
                    pAccess.set((ItemStack)p_186347_);
                });
            } else {
                int i = BundleItem.add(pStack, pOther);
                if (i > 0) {
                    this.playInsertSound(pPlayer);
                    pOther.shrink(i);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pUsedHand);
        if (BundleItem.dropContents(itemstack, pPlayer)) {
            this.playDropContentsSound(pPlayer);
            pPlayer.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResultHolder.sidedSuccess(itemstack, pLevel.isClientSide());
        }
        return InteractionResultHolder.fail(itemstack);
    }

    @Override
    public boolean isBarVisible(ItemStack pStack) {
        return BundleItem.getContentWeight(pStack) > 0;
    }

    @Override
    public int getBarWidth(ItemStack pStack) {
        return Math.min(1 + 12 * BundleItem.getContentWeight(pStack) / 64, 13);
    }

    @Override
    public int getBarColor(ItemStack pStack) {
        return BAR_COLOR;
    }

    private static int add(ItemStack pBundleStack, ItemStack pInsertedStack) {
        if (!pInsertedStack.isEmpty() && pInsertedStack.getItem().canFitInsideContainerItems()) {
            CompoundTag compoundtag = pBundleStack.getOrCreateTag();
            if (!compoundtag.contains(TAG_ITEMS)) {
                compoundtag.put(TAG_ITEMS, new ListTag());
            }
            int i = BundleItem.getContentWeight(pBundleStack);
            int j = BundleItem.getWeight(pInsertedStack);
            int k = Math.min(pInsertedStack.getCount(), (64 - i) / j);
            if (k == 0) {
                return 0;
            }
            ListTag listtag = compoundtag.getList(TAG_ITEMS, 10);
            Optional<CompoundTag> optional = BundleItem.getMatchingItem(pInsertedStack, listtag);
            if (optional.isPresent()) {
                CompoundTag compoundtag1 = optional.get();
                ItemStack itemstack = ItemStack.of(compoundtag1);
                itemstack.grow(k);
                itemstack.save(compoundtag1);
                listtag.remove(compoundtag1);
                listtag.add(0, compoundtag1);
            } else {
                ItemStack itemstack1 = pInsertedStack.copy();
                itemstack1.setCount(k);
                CompoundTag compoundtag2 = new CompoundTag();
                itemstack1.save(compoundtag2);
                listtag.add(0, compoundtag2);
            }
            return k;
        }
        return 0;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack pStack, ListTag pList) {
        return pStack.is(Items.BUNDLE) ? Optional.empty() : pList.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(p_186350_ -> ItemStack.isSameItemSameTags(ItemStack.of(p_186350_), pStack)).findFirst();
    }

    private static int getWeight(ItemStack pStack) {
        CompoundTag compoundtag;
        if (pStack.is(Items.BUNDLE)) {
            return 4 + BundleItem.getContentWeight(pStack);
        }
        if ((pStack.is(Items.BEEHIVE) || pStack.is(Items.BEE_NEST)) && pStack.hasTag() && (compoundtag = BlockItem.getBlockEntityData(pStack)) != null && !compoundtag.getList("Bees", 10).isEmpty()) {
            return 64;
        }
        return 64 / pStack.getMaxStackSize();
    }

    private static int getContentWeight(ItemStack pStack) {
        return BundleItem.getContents(pStack).mapToInt(p_186356_ -> BundleItem.getWeight(p_186356_) * p_186356_.getCount()).sum();
    }

    private static Optional<ItemStack> removeOne(ItemStack pStack) {
        CompoundTag compoundtag = pStack.getOrCreateTag();
        if (!compoundtag.contains(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.getList(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        boolean i = false;
        CompoundTag compoundtag1 = listtag.getCompound(0);
        ItemStack itemstack = ItemStack.of(compoundtag1);
        listtag.remove(0);
        if (listtag.isEmpty()) {
            pStack.removeTagKey(TAG_ITEMS);
        }
        return Optional.of(itemstack);
    }

    private static boolean dropContents(ItemStack pStack, Player pPlayer) {
        CompoundTag compoundtag = pStack.getOrCreateTag();
        if (!compoundtag.contains(TAG_ITEMS)) {
            return false;
        }
        if (pPlayer instanceof ServerPlayer) {
            ListTag listtag = compoundtag.getList(TAG_ITEMS, 10);
            int i = 0;
            while (i < listtag.size()) {
                CompoundTag compoundtag1 = listtag.getCompound(i);
                ItemStack itemstack = ItemStack.of(compoundtag1);
                pPlayer.drop(itemstack, true);
                ++i;
            }
        }
        pStack.removeTagKey(TAG_ITEMS);
        return true;
    }

    private static Stream<ItemStack> getContents(ItemStack pStack) {
        CompoundTag compoundtag = pStack.getTag();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.getList(TAG_ITEMS, 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::of);
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        NonNullList<ItemStack> nonnulllist = NonNullList.create();
        BundleItem.getContents(pStack).forEach(nonnulllist::add);
        return Optional.of(new BundleTooltip(nonnulllist, BundleItem.getContentWeight(pStack)));
    }

    @Override
    public void appendHoverText(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add(new TranslatableComponent("item.minecraft.bundle.fullness", BundleItem.getContentWeight(pStack), 64).withStyle(ChatFormatting.GRAY));
    }

    @Override
    public void onDestroyed(ItemEntity pItemEntity) {
        ItemUtils.onContainerDestroyed(pItemEntity, BundleItem.getContents(pItemEntity.getItem()));
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + p_186343_.getLevel().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity p_186352_) {
        p_186352_.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + p_186352_.getLevel().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity p_186354_) {
        p_186354_.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + p_186354_.getLevel().getRandom().nextFloat() * 0.4f);
    }
}

