/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;

public class CompassItem
extends Item
implements Vanishable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_LODESTONE_POS = "LodestonePos";
    public static final String TAG_LODESTONE_DIMENSION = "LodestoneDimension";
    public static final String TAG_LODESTONE_TRACKED = "LodestoneTracked";

    public CompassItem(Item.Properties p_40718_) {
        super(p_40718_);
    }

    public static boolean isLodestoneCompass(ItemStack pStack) {
        CompoundTag compoundtag = pStack.getTag();
        return compoundtag != null && (compoundtag.contains(TAG_LODESTONE_DIMENSION) || compoundtag.contains(TAG_LODESTONE_POS));
    }

    @Override
    public boolean isFoil(ItemStack pStack) {
        return CompassItem.isLodestoneCompass(pStack) || super.isFoil(pStack);
    }

    public static Optional<ResourceKey<Level>> getLodestoneDimension(CompoundTag pCompoundTag) {
        return Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pCompoundTag.get(TAG_LODESTONE_DIMENSION)).result();
    }

    @Override
    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pItemSlot, boolean pIsSelected) {
        if (!pLevel.isClientSide && CompassItem.isLodestoneCompass(pStack)) {
            BlockPos blockpos;
            CompoundTag compoundtag = pStack.getOrCreateTag();
            if (compoundtag.contains(TAG_LODESTONE_TRACKED) && !compoundtag.getBoolean(TAG_LODESTONE_TRACKED)) {
                return;
            }
            Optional<ResourceKey<Level>> optional = CompassItem.getLodestoneDimension(compoundtag);
            if (optional.isPresent() && optional.get() == pLevel.dimension() && compoundtag.contains(TAG_LODESTONE_POS) && (!pLevel.isInWorldBounds(blockpos = NbtUtils.readBlockPos(compoundtag.getCompound(TAG_LODESTONE_POS))) || !((ServerLevel)pLevel).getPoiManager().existsAtPosition(PoiType.LODESTONE, blockpos))) {
                compoundtag.remove(TAG_LODESTONE_POS);
            }
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext pContext) {
        boolean flag;
        BlockPos blockpos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        if (!level.getBlockState(blockpos).is(Blocks.LODESTONE)) {
            return super.useOn(pContext);
        }
        level.playSound(null, blockpos, SoundEvents.LODESTONE_COMPASS_LOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
        Player player = pContext.getPlayer();
        ItemStack itemstack = pContext.getItemInHand();
        boolean bl = flag = !player.getAbilities().instabuild && itemstack.getCount() == 1;
        if (flag) {
            this.addLodestoneTags(level.dimension(), blockpos, itemstack.getOrCreateTag());
        } else {
            ItemStack itemstack1 = new ItemStack(Items.COMPASS, 1);
            CompoundTag compoundtag = itemstack.hasTag() ? itemstack.getTag().copy() : new CompoundTag();
            itemstack1.setTag(compoundtag);
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            this.addLodestoneTags(level.dimension(), blockpos, compoundtag);
            if (!player.getInventory().add(itemstack1)) {
                player.drop(itemstack1, false);
            }
        }
        return InteractionResult.sidedSuccess(level.isClientSide);
    }

    private void addLodestoneTags(ResourceKey<Level> pLodestoneDimension, BlockPos pLodestonePos, CompoundTag pCompoundTag) {
        pCompoundTag.put(TAG_LODESTONE_POS, NbtUtils.writeBlockPos(pLodestonePos));
        Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, pLodestoneDimension).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_40731_ -> pCompoundTag.put(TAG_LODESTONE_DIMENSION, (Tag)p_40731_));
        pCompoundTag.putBoolean(TAG_LODESTONE_TRACKED, true);
    }

    @Override
    public String getDescriptionId(ItemStack pStack) {
        return CompassItem.isLodestoneCompass(pStack) ? "item.minecraft.lodestone_compass" : super.getDescriptionId(pStack);
    }
}

