/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class DebugStickItem
extends Item {
    public DebugStickItem(Item.Properties p_40948_) {
        super(p_40948_);
    }

    @Override
    public boolean isFoil(ItemStack pStack) {
        return true;
    }

    @Override
    public boolean canAttackBlock(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        if (!pLevel.isClientSide) {
            this.handleInteraction(pPlayer, pState, pLevel, pPos, false, pPlayer.getItemInHand(InteractionHand.MAIN_HAND));
        }
        return false;
    }

    @Override
    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos blockpos;
        Player player = pContext.getPlayer();
        Level level = pContext.getLevel();
        if (!level.isClientSide && player != null && !this.handleInteraction(player, level.getBlockState(blockpos = pContext.getClickedPos()), level, blockpos, true, pContext.getItemInHand())) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.sidedSuccess(level.isClientSide);
    }

    private boolean handleInteraction(Player pPlayer, BlockState pStateClicked, LevelAccessor pAccessor, BlockPos pPos, boolean pShouldCycleState, ItemStack pDebugStack) {
        if (!pPlayer.canUseGameMasterBlocks()) {
            return false;
        }
        Block block = pStateClicked.getBlock();
        StateDefinition<Block, BlockState> statedefinition = block.getStateDefinition();
        Collection<Property<?>> collection = statedefinition.getProperties();
        String s = Registry.BLOCK.getKey(block).toString();
        if (collection.isEmpty()) {
            DebugStickItem.message(pPlayer, new TranslatableComponent(String.valueOf(this.getDescriptionId()) + ".empty", s));
            return false;
        }
        CompoundTag compoundtag = pDebugStack.getOrCreateTagElement("DebugProperty");
        String s1 = compoundtag.getString(s);
        Property<?> property = statedefinition.getProperty(s1);
        if (pShouldCycleState) {
            if (property == null) {
                property = collection.iterator().next();
            }
            BlockState blockstate = DebugStickItem.cycleState(pStateClicked, property, pPlayer.isSecondaryUseActive());
            pAccessor.setBlock(pPos, blockstate, 18);
            DebugStickItem.message(pPlayer, new TranslatableComponent(String.valueOf(this.getDescriptionId()) + ".update", property.getName(), DebugStickItem.getNameHelper(blockstate, property)));
        } else {
            property = DebugStickItem.getRelative(collection, property, pPlayer.isSecondaryUseActive());
            String s2 = property.getName();
            compoundtag.putString(s, s2);
            DebugStickItem.message(pPlayer, new TranslatableComponent(String.valueOf(this.getDescriptionId()) + ".select", s2, DebugStickItem.getNameHelper(pStateClicked, property)));
        }
        return true;
    }

    private static <T extends Comparable<T>> BlockState cycleState(BlockState pState, Property<T> pProperty, boolean pBackwards) {
        return (BlockState)pState.setValue(pProperty, (Comparable)DebugStickItem.getRelative(pProperty.getPossibleValues(), pState.getValue(pProperty), pBackwards));
    }

    private static <T> T getRelative(Iterable<T> pAllowedValues, @Nullable T pCurrentValue, boolean pBackwards) {
        return pBackwards ? Util.findPreviousInIterable(pAllowedValues, pCurrentValue) : Util.findNextInIterable(pAllowedValues, pCurrentValue);
    }

    private static void message(Player pPlayer, Component pMessageComponent) {
        ((ServerPlayer)pPlayer).sendMessage(pMessageComponent, ChatType.GAME_INFO, Util.NIL_UUID);
    }

    private static <T extends Comparable<T>> String getNameHelper(BlockState pState, Property<T> pProperty) {
        return pProperty.getName(pState.getValue(pProperty));
    }
}

