/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.MaterialColor;
import net.optifine.reflect.Reflector;

public enum DyeColor implements StringRepresentable
{
    WHITE(0, "white", 0xF9FFFE, MaterialColor.SNOW, 0xF0F0F0, 0xFFFFFF),
    ORANGE(1, "orange", 16351261, MaterialColor.COLOR_ORANGE, 15435844, 16738335),
    MAGENTA(2, "magenta", 13061821, MaterialColor.COLOR_MAGENTA, 12801229, 0xFF00FF),
    LIGHT_BLUE(3, "light_blue", 3847130, MaterialColor.COLOR_LIGHT_BLUE, 6719955, 10141901),
    YELLOW(4, "yellow", 16701501, MaterialColor.COLOR_YELLOW, 14602026, 0xFFFF00),
    LIME(5, "lime", 8439583, MaterialColor.COLOR_LIGHT_GREEN, 4312372, 0xBFFF00),
    PINK(6, "pink", 15961002, MaterialColor.COLOR_PINK, 14188952, 16738740),
    GRAY(7, "gray", 4673362, MaterialColor.COLOR_GRAY, 0x434343, 0x808080),
    LIGHT_GRAY(8, "light_gray", 0x9D9D97, MaterialColor.COLOR_LIGHT_GRAY, 0xABABAB, 0xD3D3D3),
    CYAN(9, "cyan", 1481884, MaterialColor.COLOR_CYAN, 2651799, 65535),
    PURPLE(10, "purple", 8991416, MaterialColor.COLOR_PURPLE, 8073150, 10494192),
    BLUE(11, "blue", 3949738, MaterialColor.COLOR_BLUE, 2437522, 255),
    BROWN(12, "brown", 8606770, MaterialColor.COLOR_BROWN, 5320730, 9127187),
    GREEN(13, "green", 6192150, MaterialColor.COLOR_GREEN, 3887386, 65280),
    RED(14, "red", 11546150, MaterialColor.COLOR_RED, 11743532, 0xFF0000),
    BLACK(15, "black", 0x1D1D21, MaterialColor.COLOR_BLACK, 0x1E1B1B, 0);

    private static final DyeColor[] BY_ID;
    private static final Int2ObjectOpenHashMap<DyeColor> BY_FIREWORK_COLOR;
    private final int id;
    private final String name;
    private final MaterialColor color;
    private float[] textureDiffuseColors;
    private final int fireworkColor;
    private final TagKey<Item> tag;
    private final int textColor;

    static {
        BY_ID = (DyeColor[])Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::getId)).toArray(DyeColor[]::new);
        BY_FIREWORK_COLOR = new Int2ObjectOpenHashMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(p_41063_0_ -> p_41063_0_.fireworkColor, p_41055_0_ -> p_41055_0_)));
    }

    private DyeColor(int p_41046_, String p_41047_, int p_41048_, MaterialColor p_41049_, int p_41050_, int p_41051_) {
        this.id = p_41046_;
        this.name = p_41047_;
        this.color = p_41049_;
        this.textColor = p_41051_;
        int i = (p_41048_ & 0xFF0000) >> 16;
        int j = (p_41048_ & 0xFF00) >> 8;
        int k = (p_41048_ & 0xFF) >> 0;
        this.tag = (TagKey)Reflector.ForgeItemTags_create.call((Object)new ResourceLocation("forge", "dyes/" + p_41047_));
        this.textureDiffuseColors = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
        this.fireworkColor = p_41050_;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public float[] getTextureDiffuseColors() {
        return this.textureDiffuseColors;
    }

    public MaterialColor getMaterialColor() {
        return this.color;
    }

    public int getFireworkColor() {
        return this.fireworkColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public static DyeColor byId(int pColorId) {
        if (pColorId < 0 || pColorId >= BY_ID.length) {
            pColorId = 0;
        }
        return BY_ID[pColorId];
    }

    public static DyeColor byName(String pTranslationKey, DyeColor pFallback) {
        DyeColor[] dyeColorArray = DyeColor.values();
        int n = dyeColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DyeColor dyecolor = dyeColorArray[n2];
            if (dyecolor.name.equals(pTranslationKey)) {
                return dyecolor;
            }
            ++n2;
        }
        return pFallback;
    }

    @Nullable
    public static DyeColor byFireworkColor(int pFireworkColor) {
        return (DyeColor)BY_FIREWORK_COLOR.get(pFireworkColor);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public void setColorComponentValues(float[] colorComponentValues) {
        this.textureDiffuseColors = colorComponentValues;
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    @Nullable
    public static DyeColor getColor(ItemStack stack) {
        if (stack.getItem() instanceof DyeItem) {
            return ((DyeItem)stack.getItem()).getDyeColor();
        }
        DyeColor[] dyeColorArray = BY_ID;
        int n = BY_ID.length;
        int n2 = 0;
        while (n2 < n) {
            DyeColor dyecolor = dyeColorArray[n2];
            if (stack.is(dyecolor.getTag())) {
                return dyecolor;
            }
            ++n2;
        }
        return null;
    }
}

