/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DyeItem
extends Item {
    private static final Map<DyeColor, DyeItem> ITEM_BY_COLOR = Maps.newEnumMap(DyeColor.class);
    private final DyeColor dyeColor;

    public DyeItem(DyeColor pDyeColor, Item.Properties pProperties) {
        super(pProperties);
        this.dyeColor = pDyeColor;
        ITEM_BY_COLOR.put(pDyeColor, this);
    }

    @Override
    public InteractionResult interactLivingEntity(ItemStack pStack, Player pPlayer, LivingEntity pTarget, InteractionHand pHand) {
        Sheep sheep;
        if (pTarget instanceof Sheep && (sheep = (Sheep)pTarget).isAlive() && !sheep.isSheared() && sheep.getColor() != this.dyeColor) {
            sheep.level.playSound(pPlayer, sheep, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!pPlayer.level.isClientSide) {
                sheep.setColor(this.dyeColor);
                pStack.shrink(1);
            }
            return InteractionResult.sidedSuccess(pPlayer.level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public static DyeItem byColor(DyeColor pColor) {
        return ITEM_BY_COLOR.get(pColor);
    }
}

