/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface DyeableLeatherItem {
    public static final String TAG_COLOR = "color";
    public static final String TAG_DISPLAY = "display";
    public static final int DEFAULT_LEATHER_COLOR = 10511680;

    default public boolean hasCustomColor(ItemStack pStack) {
        CompoundTag compoundtag = pStack.getTagElement(TAG_DISPLAY);
        return compoundtag != null && compoundtag.contains(TAG_COLOR, 99);
    }

    default public int getColor(ItemStack pStack) {
        CompoundTag compoundtag = pStack.getTagElement(TAG_DISPLAY);
        return compoundtag != null && compoundtag.contains(TAG_COLOR, 99) ? compoundtag.getInt(TAG_COLOR) : 10511680;
    }

    default public void clearColor(ItemStack pStack) {
        CompoundTag compoundtag = pStack.getTagElement(TAG_DISPLAY);
        if (compoundtag != null && compoundtag.contains(TAG_COLOR)) {
            compoundtag.remove(TAG_COLOR);
        }
    }

    default public void setColor(ItemStack pStack, int pColor) {
        pStack.getOrCreateTagElement(TAG_DISPLAY).putInt(TAG_COLOR, pColor);
    }

    public static ItemStack dyeArmor(ItemStack pStack, List<DyeItem> pDyes) {
        ItemStack itemstack = ItemStack.EMPTY;
        int[] aint = new int[3];
        int i = 0;
        int j = 0;
        DyeableLeatherItem dyeableleatheritem = null;
        Item item = pStack.getItem();
        if (item instanceof DyeableLeatherItem) {
            dyeableleatheritem = (DyeableLeatherItem)((Object)item);
            itemstack = pStack.copy();
            itemstack.setCount(1);
            if (dyeableleatheritem.hasCustomColor(pStack)) {
                int k = dyeableleatheritem.getColor(itemstack);
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                i += (int)(Math.max(f, Math.max(f1, f2)) * 255.0f);
                aint[0] = aint[0] + (int)(f * 255.0f);
                aint[1] = aint[1] + (int)(f1 * 255.0f);
                aint[2] = aint[2] + (int)(f2 * 255.0f);
                ++j;
            }
            for (DyeItem dyeitem : pDyes) {
                float[] afloat = dyeitem.getDyeColor().getTextureDiffuseColors();
                int i2 = (int)(afloat[0] * 255.0f);
                int l = (int)(afloat[1] * 255.0f);
                int i1 = (int)(afloat[2] * 255.0f);
                i += Math.max(i2, Math.max(l, i1));
                aint[0] = aint[0] + i2;
                aint[1] = aint[1] + l;
                aint[2] = aint[2] + i1;
                ++j;
            }
        }
        if (dyeableleatheritem == null) {
            return ItemStack.EMPTY;
        }
        int j1 = aint[0] / j;
        int k1 = aint[1] / j;
        int l1 = aint[2] / j;
        float f3 = (float)i / (float)j;
        float f4 = Math.max(j1, Math.max(k1, l1));
        j1 = (int)((float)j1 * f3 / f4);
        k1 = (int)((float)k1 * f3 / f4);
        l1 = (int)((float)l1 * f3 / f4);
        int j2 = (j1 << 8) + k1;
        j2 = (j2 << 8) + l1;
        dyeableleatheritem.setColor(itemstack, j2);
        return itemstack;
    }
}

