/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;

public class EmptyMapItem
extends ComplexItem {
    public EmptyMapItem(Item.Properties p_41143_) {
        super(p_41143_);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (pLevel.isClientSide) {
            return InteractionResultHolder.success(itemstack);
        }
        if (!pPlayer.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        pPlayer.awardStat(Stats.ITEM_USED.get(this));
        pPlayer.level.playSound(null, pPlayer, SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, pPlayer.getSoundSource(), 1.0f, 1.0f);
        ItemStack itemstack1 = MapItem.create(pLevel, pPlayer.getBlockX(), pPlayer.getBlockZ(), (byte)0, true, false);
        if (itemstack.isEmpty()) {
            return InteractionResultHolder.consume(itemstack1);
        }
        if (!pPlayer.getInventory().add(itemstack1.copy())) {
            pPlayer.drop(itemstack1, false);
        }
        return InteractionResultHolder.consume(itemstack);
    }
}

