/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;

public class EnchantedBookItem
extends Item {
    public static final String TAG_STORED_ENCHANTMENTS = "StoredEnchantments";

    public EnchantedBookItem(Item.Properties p_41149_) {
        super(p_41149_);
    }

    @Override
    public boolean isFoil(ItemStack pStack) {
        return true;
    }

    @Override
    public boolean isEnchantable(ItemStack pStack) {
        return false;
    }

    public static ListTag getEnchantments(ItemStack pEnchantedBookStack) {
        CompoundTag compoundtag = pEnchantedBookStack.getTag();
        return compoundtag != null ? compoundtag.getList(TAG_STORED_ENCHANTMENTS, 10) : new ListTag();
    }

    @Override
    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.appendHoverText(pStack, pLevel, pTooltip, pFlag);
        ItemStack.appendEnchantmentNames(pTooltip, EnchantedBookItem.getEnchantments(pStack));
    }

    public static void addEnchantment(ItemStack pStack, EnchantmentInstance pInstance) {
        ListTag listtag = EnchantedBookItem.getEnchantments(pStack);
        boolean flag = true;
        ResourceLocation resourcelocation = EnchantmentHelper.getEnchantmentId(pInstance.enchantment);
        int i = 0;
        while (i < listtag.size()) {
            CompoundTag compoundtag = listtag.getCompound(i);
            ResourceLocation resourcelocation1 = EnchantmentHelper.getEnchantmentId(compoundtag);
            if (resourcelocation1 != null && resourcelocation1.equals(resourcelocation)) {
                if (EnchantmentHelper.getEnchantmentLevel(compoundtag) < pInstance.level) {
                    EnchantmentHelper.setEnchantmentLevel(compoundtag, pInstance.level);
                }
                flag = false;
                break;
            }
            ++i;
        }
        if (flag) {
            listtag.add(EnchantmentHelper.storeEnchantment(resourcelocation, pInstance.level));
        }
        pStack.getOrCreateTag().put(TAG_STORED_ENCHANTMENTS, listtag);
    }

    public static ItemStack createForEnchantment(EnchantmentInstance pInstance) {
        ItemStack itemstack = new ItemStack(Items.ENCHANTED_BOOK);
        EnchantedBookItem.addEnchantment(itemstack, pInstance);
        return itemstack;
    }

    @Override
    public void fillItemCategory(CreativeModeTab pGroup, NonNullList<ItemStack> pItems) {
        block4: {
            block3: {
                if (pGroup != CreativeModeTab.TAB_SEARCH) break block3;
                for (Enchantment enchantment : Registry.ENCHANTMENT) {
                    if (enchantment.category == null) continue;
                    int i = enchantment.getMinLevel();
                    while (i <= enchantment.getMaxLevel()) {
                        pItems.add(EnchantedBookItem.createForEnchantment(new EnchantmentInstance(enchantment, i)));
                        ++i;
                    }
                }
                break block4;
            }
            if (pGroup.getEnchantmentCategories().length == 0) break block4;
            for (Enchantment enchantment1 : Registry.ENCHANTMENT) {
                if (!pGroup.hasEnchantmentCategory(enchantment1.category)) continue;
                pItems.add(EnchantedBookItem.createForEnchantment(new EnchantmentInstance(enchantment1, enchantment1.getMaxLevel())));
            }
        }
    }
}

