/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ConfiguredStructureTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EnderEyeItem
extends Item {
    public EnderEyeItem(Item.Properties p_41180_) {
        super(p_41180_);
    }

    @Override
    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos blockpos;
        Level level = pContext.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = pContext.getClickedPos());
        if (blockstate.is(Blocks.END_PORTAL_FRAME) && !blockstate.getValue(EndPortalFrameBlock.HAS_EYE).booleanValue()) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            BlockState blockstate1 = (BlockState)blockstate.setValue(EndPortalFrameBlock.HAS_EYE, true);
            Block.pushEntitiesUp(blockstate, blockstate1, level, blockpos);
            level.setBlock(blockpos, blockstate1, 2);
            level.updateNeighbourForOutputSignal(blockpos, Blocks.END_PORTAL_FRAME);
            pContext.getItemInHand().shrink(1);
            level.levelEvent(1503, blockpos, 0);
            BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = EndPortalFrameBlock.getOrCreatePortalShape().find(level, blockpos);
            if (blockpattern$blockpatternmatch != null) {
                BlockPos blockpos1 = blockpattern$blockpatternmatch.getFrontTopLeft().offset(-3, 0, -3);
                int i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 3) {
                        level.setBlock(blockpos1.offset(i, 0, j), Blocks.END_PORTAL.defaultBlockState(), 2);
                        ++j;
                    }
                    ++i;
                }
                level.globalLevelEvent(1038, blockpos1.offset(1, 0, 1), 0);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ServerLevel serverlevel;
        BlockPos blockpos;
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        BlockHitResult hitresult = EnderEyeItem.getPlayerPOVHitResult(pLevel, pPlayer, ClipContext.Fluid.NONE);
        if (((HitResult)hitresult).getType() == HitResult.Type.BLOCK && pLevel.getBlockState(hitresult.getBlockPos()).is(Blocks.END_PORTAL_FRAME)) {
            return InteractionResultHolder.pass(itemstack);
        }
        pPlayer.startUsingItem(pHand);
        if (pLevel instanceof ServerLevel && (blockpos = (serverlevel = (ServerLevel)pLevel).findNearestMapFeature(ConfiguredStructureTags.EYE_OF_ENDER_LOCATED, pPlayer.blockPosition(), 100, false)) != null) {
            EyeOfEnder eyeofender = new EyeOfEnder(pLevel, pPlayer.getX(), pPlayer.getY(0.5), pPlayer.getZ());
            eyeofender.setItem(itemstack);
            eyeofender.signalTo(blockpos);
            pLevel.addFreshEntity(eyeofender);
            if (pPlayer instanceof ServerPlayer) {
                CriteriaTriggers.USED_ENDER_EYE.trigger((ServerPlayer)pPlayer, blockpos);
            }
            pLevel.playSound(null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
            pLevel.levelEvent(null, 1003, pPlayer.blockPosition(), 0);
            if (!pPlayer.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            pPlayer.awardStat(Stats.ITEM_USED.get(this));
            pPlayer.swing(pHand, true);
            return InteractionResultHolder.success(itemstack);
        }
        return InteractionResultHolder.consume(itemstack);
    }
}

