/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.FireworkStarItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireworkRocketItem
extends Item {
    public static final String TAG_FIREWORKS = "Fireworks";
    public static final String TAG_EXPLOSION = "Explosion";
    public static final String TAG_EXPLOSIONS = "Explosions";
    public static final String TAG_FLIGHT = "Flight";
    public static final String TAG_EXPLOSION_TYPE = "Type";
    public static final String TAG_EXPLOSION_TRAIL = "Trail";
    public static final String TAG_EXPLOSION_FLICKER = "Flicker";
    public static final String TAG_EXPLOSION_COLORS = "Colors";
    public static final String TAG_EXPLOSION_FADECOLORS = "FadeColors";
    public static final double ROCKET_PLACEMENT_OFFSET = 0.15;

    public FireworkRocketItem(Item.Properties p_41209_) {
        super(p_41209_);
    }

    @Override
    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        if (!level.isClientSide) {
            ItemStack itemstack = pContext.getItemInHand();
            Vec3 vec3 = pContext.getClickLocation();
            Direction direction = pContext.getClickedFace();
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(level, pContext.getPlayer(), vec3.x + (double)direction.getStepX() * 0.15, vec3.y + (double)direction.getStepY() * 0.15, vec3.z + (double)direction.getStepZ() * 0.15, itemstack);
            level.addFreshEntity(fireworkrocketentity);
            itemstack.shrink(1);
        }
        return InteractionResult.sidedSuccess(level.isClientSide);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        if (pPlayer.isFallFlying()) {
            ItemStack itemstack = pPlayer.getItemInHand(pHand);
            if (!pLevel.isClientSide) {
                FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(pLevel, itemstack, pPlayer);
                pLevel.addFreshEntity(fireworkrocketentity);
                if (!pPlayer.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                pPlayer.awardStat(Stats.ITEM_USED.get(this));
            }
            return InteractionResultHolder.sidedSuccess(pPlayer.getItemInHand(pHand), pLevel.isClientSide());
        }
        return InteractionResultHolder.pass(pPlayer.getItemInHand(pHand));
    }

    @Override
    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        CompoundTag compoundtag = pStack.getTagElement(TAG_FIREWORKS);
        if (compoundtag != null) {
            ListTag listtag;
            if (compoundtag.contains(TAG_FLIGHT, 99)) {
                pTooltip.add(new TranslatableComponent("item.minecraft.firework_rocket.flight").append(" ").append(String.valueOf(compoundtag.getByte(TAG_FLIGHT))).withStyle(ChatFormatting.GRAY));
            }
            if (!(listtag = compoundtag.getList(TAG_EXPLOSIONS, 10)).isEmpty()) {
                int i = 0;
                while (i < listtag.size()) {
                    CompoundTag compoundtag1 = listtag.getCompound(i);
                    ArrayList list = Lists.newArrayList();
                    FireworkStarItem.appendHoverText(compoundtag1, list);
                    if (!list.isEmpty()) {
                        int j = 1;
                        while (j < list.size()) {
                            list.set(j, new TextComponent("  ").append((Component)list.get(j)).withStyle(ChatFormatting.GRAY));
                            ++j;
                        }
                        pTooltip.addAll(list);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public ItemStack getDefaultInstance() {
        ItemStack itemstack = new ItemStack(this);
        itemstack.getOrCreateTag().putByte(TAG_FLIGHT, (byte)1);
        return itemstack;
    }

    public static enum Shape {
        SMALL_BALL(0, "small_ball"),
        LARGE_BALL(1, "large_ball"),
        STAR(2, "star"),
        CREEPER(3, "creeper"),
        BURST(4, "burst");

        private static final Shape[] BY_ID;
        private final int id;
        private final String name;

        static {
            BY_ID = (Shape[])Arrays.stream(Shape.values()).sorted(Comparator.comparingInt(p_41240_ -> p_41240_.id)).toArray(Shape[]::new);
        }

        private Shape(int p_41234_, String p_41235_) {
            this.id = p_41234_;
            this.name = p_41235_;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Shape byId(int pIndex) {
            return pIndex >= 0 && pIndex < BY_ID.length ? BY_ID[pIndex] : SMALL_BALL;
        }
    }
}

