/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FireworkStarItem
extends Item {
    public FireworkStarItem(Item.Properties p_41248_) {
        super(p_41248_);
    }

    @Override
    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        CompoundTag compoundtag = pStack.getTagElement("Explosion");
        if (compoundtag != null) {
            FireworkStarItem.appendHoverText(compoundtag, pTooltip);
        }
    }

    public static void appendHoverText(CompoundTag pCompound, List<Component> pTooltipComponents) {
        int[] aint1;
        FireworkRocketItem.Shape fireworkrocketitem$shape = FireworkRocketItem.Shape.byId(pCompound.getByte("Type"));
        pTooltipComponents.add(new TranslatableComponent("item.minecraft.firework_star.shape." + fireworkrocketitem$shape.getName()).withStyle(ChatFormatting.GRAY));
        int[] aint = pCompound.getIntArray("Colors");
        if (aint.length > 0) {
            pTooltipComponents.add(FireworkStarItem.a(new TextComponent("").withStyle(ChatFormatting.GRAY), aint));
        }
        if ((aint1 = pCompound.getIntArray("FadeColors")).length > 0) {
            pTooltipComponents.add(FireworkStarItem.a(new TranslatableComponent("item.minecraft.firework_star.fade_to").append(" ").withStyle(ChatFormatting.GRAY), aint1));
        }
        if (pCompound.getBoolean("Trail")) {
            pTooltipComponents.add(new TranslatableComponent("item.minecraft.firework_star.trail").withStyle(ChatFormatting.GRAY));
        }
        if (pCompound.getBoolean("Flicker")) {
            pTooltipComponents.add(new TranslatableComponent("item.minecraft.firework_star.flicker").withStyle(ChatFormatting.GRAY));
        }
    }

    private static Component a(MutableComponent p_41260_, int[] p_41261_) {
        int i = 0;
        while (i < p_41261_.length) {
            if (i > 0) {
                p_41260_.append(", ");
            }
            p_41260_.append(FireworkStarItem.getColorName(p_41261_[i]));
            ++i;
        }
        return p_41260_;
    }

    private static Component getColorName(int pColor) {
        DyeColor dyecolor = DyeColor.byFireworkColor(pColor);
        return dyecolor == null ? new TranslatableComponent("item.minecraft.firework_star.custom_color") : new TranslatableComponent("item.minecraft.firework_star." + dyecolor.getName());
    }
}

