/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;

public class ItemCooldowns {
    private final Map<Item, CooldownInstance> cooldowns = Maps.newHashMap();
    private int tickCount;

    public boolean isOnCooldown(Item pItem) {
        return this.getCooldownPercent(pItem, 0.0f) > 0.0f;
    }

    public float getCooldownPercent(Item pItem, float pPartialTicks) {
        CooldownInstance itemcooldowns$cooldowninstance = this.cooldowns.get(pItem);
        if (itemcooldowns$cooldowninstance != null) {
            float f = itemcooldowns$cooldowninstance.endTime - itemcooldowns$cooldowninstance.startTime;
            float f1 = (float)itemcooldowns$cooldowninstance.endTime - ((float)this.tickCount + pPartialTicks);
            return Mth.clamp(f1 / f, 0.0f, 1.0f);
        }
        return 0.0f;
    }

    public void tick() {
        ++this.tickCount;
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<Item, CooldownInstance>> iterator = this.cooldowns.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Item, CooldownInstance> entry = iterator.next();
                if (entry.getValue().endTime > this.tickCount) continue;
                iterator.remove();
                this.onCooldownEnded(entry.getKey());
            }
        }
    }

    public void addCooldown(Item pItem, int pTicks) {
        this.cooldowns.put(pItem, new CooldownInstance(this.tickCount, this.tickCount + pTicks));
        this.onCooldownStarted(pItem, pTicks);
    }

    public void removeCooldown(Item pItem) {
        this.cooldowns.remove(pItem);
        this.onCooldownEnded(pItem);
    }

    protected void onCooldownStarted(Item pItem, int pTicks) {
    }

    protected void onCooldownEnded(Item pItem) {
    }

    static class CooldownInstance {
        final int startTime;
        final int endTime;

        CooldownInstance(int p_186358_, int p_186359_) {
            this.startTime = p_186358_;
            this.endTime = p_186359_;
        }
    }
}

