/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.stream.Stream;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemUtils {
    public static InteractionResultHolder<ItemStack> startUsingInstantly(Level pLevel, Player pPlayer, InteractionHand pHand) {
        pPlayer.startUsingItem(pHand);
        return InteractionResultHolder.consume(pPlayer.getItemInHand(pHand));
    }

    public static ItemStack createFilledResult(ItemStack pEmptyStack, Player pPlayer, ItemStack pFilledStack, boolean pPreventDuplicates) {
        boolean flag = pPlayer.getAbilities().instabuild;
        if (pPreventDuplicates && flag) {
            if (!pPlayer.getInventory().contains(pFilledStack)) {
                pPlayer.getInventory().add(pFilledStack);
            }
            return pEmptyStack;
        }
        if (!flag) {
            pEmptyStack.shrink(1);
        }
        if (pEmptyStack.isEmpty()) {
            return pFilledStack;
        }
        if (!pPlayer.getInventory().add(pFilledStack)) {
            pPlayer.drop(pFilledStack, false);
        }
        return pEmptyStack;
    }

    public static ItemStack createFilledResult(ItemStack pEmptyStack, Player pPlayer, ItemStack pFilledStack) {
        return ItemUtils.createFilledResult(pEmptyStack, pPlayer, pFilledStack, true);
    }

    public static void onContainerDestroyed(ItemEntity pItemEntity, Stream<ItemStack> pContainerContents) {
        Level level = pItemEntity.level;
        if (!level.isClientSide) {
            pContainerContents.forEach(p_150955_2_ -> level.addFreshEntity(new ItemEntity(level, pItemEntity.getX(), pItemEntity.getY(), pItemEntity.getZ(), (ItemStack)p_150955_2_)));
        }
    }
}

