/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class KnowledgeBookItem
extends Item {
    private static final String RECIPE_TAG = "Recipes";
    private static final Logger LOGGER = LogUtils.getLogger();

    public KnowledgeBookItem(Item.Properties p_42822_) {
        super(p_42822_);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        CompoundTag compoundtag = itemstack.getTag();
        if (!pPlayer.getAbilities().instabuild) {
            pPlayer.setItemInHand(pHand, ItemStack.EMPTY);
        }
        if (compoundtag != null && compoundtag.contains(RECIPE_TAG, 9)) {
            if (!pLevel.isClientSide) {
                ListTag listtag = compoundtag.getList(RECIPE_TAG, 8);
                ArrayList list = Lists.newArrayList();
                RecipeManager recipemanager = pLevel.getServer().getRecipeManager();
                int i = 0;
                while (i < listtag.size()) {
                    String s = listtag.getString(i);
                    Optional<Recipe<?>> optional = recipemanager.byKey(new ResourceLocation(s));
                    if (!optional.isPresent()) {
                        LOGGER.error("Invalid recipe: {}", (Object)s);
                        return InteractionResultHolder.fail(itemstack);
                    }
                    list.add(optional.get());
                    ++i;
                }
                pPlayer.awardRecipes(list);
                pPlayer.awardStat(Stats.ITEM_USED.get(this));
            }
            return InteractionResultHolder.sidedSuccess(itemstack, pLevel.isClientSide());
        }
        LOGGER.error("Tag not valid: {}", (Object)compoundtag);
        return InteractionResultHolder.fail(itemstack);
    }
}

