/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ComplexItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapItem
extends ComplexItem {
    public static final int IMAGE_WIDTH = 128;
    public static final int IMAGE_HEIGHT = 128;
    private static final int DEFAULT_MAP_COLOR = -12173266;
    private static final String TAG_MAP = "map";

    public MapItem(Item.Properties p_42847_) {
        super(p_42847_);
    }

    public static ItemStack create(Level pLevel, int pLevelX, int pLevelZ, byte pScale, boolean pTrackingPosition, boolean pUnlimitedTracking) {
        ItemStack itemstack = new ItemStack(Items.FILLED_MAP);
        MapItem.createAndStoreSavedData(itemstack, pLevel, pLevelX, pLevelZ, pScale, pTrackingPosition, pUnlimitedTracking, pLevel.dimension());
        return itemstack;
    }

    @Nullable
    public static MapItemSavedData getSavedData(@Nullable Integer pMapId, Level pLevel) {
        return pMapId == null ? null : pLevel.getMapData(MapItem.makeKey(pMapId));
    }

    @Nullable
    public static MapItemSavedData getSavedData(ItemStack pMapId, Level pLevel) {
        Integer integer = MapItem.getMapId(pMapId);
        return MapItem.getSavedData(integer, pLevel);
    }

    @Nullable
    public static Integer getMapId(ItemStack pStack) {
        CompoundTag compoundtag = pStack.getTag();
        return compoundtag != null && compoundtag.contains(TAG_MAP, 99) ? Integer.valueOf(compoundtag.getInt(TAG_MAP)) : null;
    }

    private static int createNewSavedData(Level pLevel, int pX, int pZ, int pScale, boolean pTrackingPosition, boolean pUnlimitedTracking, ResourceKey<Level> pDimension) {
        MapItemSavedData mapitemsaveddata = MapItemSavedData.createFresh(pX, pZ, (byte)pScale, pTrackingPosition, pUnlimitedTracking, pDimension);
        int i = pLevel.getFreeMapId();
        pLevel.setMapData(MapItem.makeKey(i), mapitemsaveddata);
        return i;
    }

    private static void storeMapData(ItemStack pStack, int pMapId) {
        pStack.getOrCreateTag().putInt(TAG_MAP, pMapId);
    }

    private static void createAndStoreSavedData(ItemStack pStack, Level pLevel, int pX, int pZ, int pScale, boolean pTrackingPosition, boolean pUnlimitedTracking, ResourceKey<Level> pDimension) {
        int i = MapItem.createNewSavedData(pLevel, pX, pZ, pScale, pTrackingPosition, pUnlimitedTracking, pDimension);
        MapItem.storeMapData(pStack, i);
    }

    public static String makeKey(int pMapId) {
        return "map_" + pMapId;
    }

    public void update(Level pLevel, Entity pViewer, MapItemSavedData pData) {
        if (pLevel.dimension() == pData.dimension && pViewer instanceof Player) {
            int i = 1 << pData.scale;
            int j = pData.x;
            int k = pData.z;
            int l = Mth.floor(pViewer.getX() - (double)j) / i + 64;
            int i1 = Mth.floor(pViewer.getZ() - (double)k) / i + 64;
            int j1 = 128 / i;
            if (pLevel.dimensionType().hasCeiling()) {
                j1 /= 2;
            }
            MapItemSavedData.HoldingPlayer mapitemsaveddata$holdingplayer = pData.getHoldingPlayer((Player)pViewer);
            ++mapitemsaveddata$holdingplayer.step;
            boolean flag = false;
            int k1 = l - j1 + 1;
            while (k1 < l + j1) {
                if ((k1 & 0xF) == (mapitemsaveddata$holdingplayer.step & 0xF) || flag) {
                    flag = false;
                    double d0 = 0.0;
                    int l1 = i1 - j1 - 1;
                    while (l1 < i1 + j1) {
                        if (k1 >= 0 && l1 >= -1 && k1 < 128 && l1 < 128) {
                            int i2 = k1 - l;
                            int j2 = l1 - i1;
                            boolean flag1 = i2 * i2 + j2 * j2 > (j1 - 2) * (j1 - 2);
                            int k2 = (j / i + k1 - 64) * i;
                            int l2 = (k / i + l1 - 64) * i;
                            LinkedHashMultiset multiset = LinkedHashMultiset.create();
                            LevelChunk levelchunk = pLevel.getChunkAt(new BlockPos(k2, 0, l2));
                            if (!levelchunk.isEmpty()) {
                                double d3;
                                double d2;
                                ChunkPos chunkpos = levelchunk.getPos();
                                int i3 = k2 & 0xF;
                                int j3 = l2 & 0xF;
                                int k3 = 0;
                                double d1 = 0.0;
                                if (pLevel.dimensionType().hasCeiling()) {
                                    int l3 = k2 + l2 * 231871;
                                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                                        multiset.add((Object)Blocks.DIRT.defaultBlockState().getMapColor(pLevel, BlockPos.ZERO), 10);
                                    } else {
                                        multiset.add((Object)Blocks.STONE.defaultBlockState().getMapColor(pLevel, BlockPos.ZERO), 100);
                                    }
                                    d1 = 100.0;
                                } else {
                                    BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                                    BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                                    int i4 = 0;
                                    while (i4 < i) {
                                        int j4 = 0;
                                        while (j4 < i) {
                                            BlockState blockstate;
                                            int k4 = levelchunk.getHeight(Heightmap.Types.WORLD_SURFACE, i4 + i3, j4 + j3) + 1;
                                            if (k4 <= pLevel.getMinBuildHeight() + 1) {
                                                blockstate = Blocks.BEDROCK.defaultBlockState();
                                            } else {
                                                do {
                                                    blockpos$mutableblockpos1.set(chunkpos.getMinBlockX() + i4 + i3, --k4, chunkpos.getMinBlockZ() + j4 + j3);
                                                } while ((blockstate = levelchunk.getBlockState(blockpos$mutableblockpos1)).getMapColor(pLevel, blockpos$mutableblockpos1) == MaterialColor.NONE && k4 > pLevel.getMinBuildHeight());
                                                if (k4 > pLevel.getMinBuildHeight() && !blockstate.getFluidState().isEmpty()) {
                                                    BlockState blockstate1;
                                                    int l4 = k4 - 1;
                                                    blockpos$mutableblockpos.set(blockpos$mutableblockpos1);
                                                    do {
                                                        blockpos$mutableblockpos.setY(l4--);
                                                        blockstate1 = levelchunk.getBlockState(blockpos$mutableblockpos);
                                                        ++k3;
                                                    } while (l4 > pLevel.getMinBuildHeight() && !blockstate1.getFluidState().isEmpty());
                                                    blockstate = this.getCorrectStateForFluidBlock(pLevel, blockstate, blockpos$mutableblockpos1);
                                                }
                                            }
                                            pData.checkBanners(pLevel, chunkpos.getMinBlockX() + i4 + i3, chunkpos.getMinBlockZ() + j4 + j3);
                                            d1 += (double)k4 / (double)(i * i);
                                            multiset.add((Object)blockstate.getMapColor(pLevel, blockpos$mutableblockpos1));
                                            ++j4;
                                        }
                                        ++i4;
                                    }
                                }
                                MaterialColor materialcolor = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialColor.NONE);
                                MaterialColor.Brightness materialcolor$brightness = materialcolor == MaterialColor.WATER ? ((d2 = (double)(k3 /= i * i) * 0.1 + (double)(k1 + l1 & 1) * 0.2) < 0.5 ? MaterialColor.Brightness.HIGH : (d2 > 0.9 ? MaterialColor.Brightness.LOW : MaterialColor.Brightness.NORMAL)) : ((d3 = (d1 - d0) * 4.0 / (double)(i + 4) + ((double)(k1 + l1 & 1) - 0.5) * 0.4) > 0.6 ? MaterialColor.Brightness.HIGH : (d3 < -0.6 ? MaterialColor.Brightness.LOW : MaterialColor.Brightness.NORMAL));
                                d0 = d1;
                                if (!(l1 < 0 || i2 * i2 + j2 * j2 >= j1 * j1 || flag1 && (k1 + l1 & 1) == 0)) {
                                    flag |= pData.updateColor(k1, l1, materialcolor.getPackedId(materialcolor$brightness));
                                }
                            }
                        }
                        ++l1;
                    }
                }
                ++k1;
            }
        }
    }

    private BlockState getCorrectStateForFluidBlock(Level pLevel, BlockState pState, BlockPos pPos) {
        FluidState fluidstate = pState.getFluidState();
        return !fluidstate.isEmpty() && !pState.isFaceSturdy(pLevel, pPos, Direction.UP) ? fluidstate.createLegacyBlock() : pState;
    }

    private static boolean a(boolean[] p_212252_, int p_212253_, int p_212254_) {
        return p_212252_[p_212254_ * 128 + p_212253_];
    }

    public static void renderBiomePreviewMap(ServerLevel pServerLevel, ItemStack pStack) {
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData(pStack, (Level)pServerLevel);
        if (mapitemsaveddata != null && pServerLevel.dimension() == mapitemsaveddata.dimension) {
            int i = 1 << mapitemsaveddata.scale;
            int j = mapitemsaveddata.x;
            int k = mapitemsaveddata.z;
            boolean[] aboolean = new boolean[16384];
            int l = j / i - 64;
            int i1 = k / i - 64;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            int j1 = 0;
            while (j1 < 128) {
                int k1 = 0;
                while (k1 < 128) {
                    Biome.BiomeCategory biome$biomecategory = Biome.getBiomeCategory(pServerLevel.getBiome(blockpos$mutableblockpos.set((l + k1) * i, 0, (i1 + j1) * i)));
                    aboolean[j1 * 128 + k1] = biome$biomecategory == Biome.BiomeCategory.OCEAN || biome$biomecategory == Biome.BiomeCategory.RIVER || biome$biomecategory == Biome.BiomeCategory.SWAMP;
                    ++k1;
                }
                ++j1;
            }
            int j2 = 1;
            while (j2 < 127) {
                int k2 = 1;
                while (k2 < 127) {
                    int l2 = 0;
                    int l1 = -1;
                    while (l1 < 2) {
                        int i2 = -1;
                        while (i2 < 2) {
                            if ((l1 != 0 || i2 != 0) && MapItem.a(aboolean, j2 + l1, k2 + i2)) {
                                ++l2;
                            }
                            ++i2;
                        }
                        ++l1;
                    }
                    MaterialColor.Brightness materialcolor$brightness = MaterialColor.Brightness.LOWEST;
                    MaterialColor materialcolor = MaterialColor.NONE;
                    if (MapItem.a(aboolean, j2, k2)) {
                        materialcolor = MaterialColor.COLOR_ORANGE;
                        if (l2 > 7 && k2 % 2 == 0) {
                            switch ((j2 + (int)(Mth.sin((float)k2 + 0.0f) * 7.0f)) / 8 % 5) {
                                case 0: 
                                case 4: {
                                    materialcolor$brightness = MaterialColor.Brightness.LOW;
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    materialcolor$brightness = MaterialColor.Brightness.NORMAL;
                                    break;
                                }
                                case 2: {
                                    materialcolor$brightness = MaterialColor.Brightness.HIGH;
                                }
                            }
                        } else if (l2 > 7) {
                            materialcolor = MaterialColor.NONE;
                        } else if (l2 > 5) {
                            materialcolor$brightness = MaterialColor.Brightness.NORMAL;
                        } else if (l2 > 3) {
                            materialcolor$brightness = MaterialColor.Brightness.LOW;
                        } else if (l2 > 1) {
                            materialcolor$brightness = MaterialColor.Brightness.LOW;
                        }
                    } else if (l2 > 0) {
                        materialcolor = MaterialColor.COLOR_BROWN;
                        materialcolor$brightness = l2 > 3 ? MaterialColor.Brightness.NORMAL : MaterialColor.Brightness.LOWEST;
                    }
                    if (materialcolor != MaterialColor.NONE) {
                        mapitemsaveddata.setColor(j2, k2, materialcolor.getPackedId(materialcolor$brightness));
                    }
                    ++k2;
                }
                ++j2;
            }
        }
    }

    @Override
    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pItemSlot, boolean pIsSelected) {
        MapItemSavedData mapitemsaveddata;
        if (!pLevel.isClientSide && (mapitemsaveddata = MapItem.getSavedData(pStack, pLevel)) != null) {
            if (pEntity instanceof Player) {
                Player player = (Player)pEntity;
                mapitemsaveddata.tickCarriedBy(player, pStack);
            }
            if (!mapitemsaveddata.locked && (pIsSelected || pEntity instanceof Player && ((Player)pEntity).getOffhandItem() == pStack)) {
                this.update(pLevel, pEntity, mapitemsaveddata);
            }
        }
    }

    @Override
    @Nullable
    public Packet<?> getUpdatePacket(ItemStack pStack, Level pLevel, Player pPlayer) {
        Integer integer = MapItem.getMapId(pStack);
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData(integer, pLevel);
        return mapitemsaveddata != null ? mapitemsaveddata.getUpdatePacket(integer, pPlayer) : null;
    }

    @Override
    public void onCraftedBy(ItemStack pStack, Level pLevel, Player pPlayer) {
        CompoundTag compoundtag = pStack.getTag();
        if (compoundtag != null && compoundtag.contains("map_scale_direction", 99)) {
            MapItem.scaleMap(pStack, pLevel, compoundtag.getInt("map_scale_direction"));
            compoundtag.remove("map_scale_direction");
        } else if (compoundtag != null && compoundtag.contains("map_to_lock", 1) && compoundtag.getBoolean("map_to_lock")) {
            MapItem.lockMap(pLevel, pStack);
            compoundtag.remove("map_to_lock");
        }
    }

    private static void scaleMap(ItemStack pStack, Level pLevel, int pScale) {
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData(pStack, pLevel);
        if (mapitemsaveddata != null) {
            int i = pLevel.getFreeMapId();
            pLevel.setMapData(MapItem.makeKey(i), mapitemsaveddata.scaled(pScale));
            MapItem.storeMapData(pStack, i);
        }
    }

    public static void lockMap(Level pLevel, ItemStack pStack) {
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData(pStack, pLevel);
        if (mapitemsaveddata != null) {
            int i = pLevel.getFreeMapId();
            String s = MapItem.makeKey(i);
            MapItemSavedData mapitemsaveddata1 = mapitemsaveddata.locked();
            pLevel.setMapData(s, mapitemsaveddata1);
            MapItem.storeMapData(pStack, i);
        }
    }

    @Override
    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        MapItemSavedData mapitemsaveddata;
        Integer integer = MapItem.getMapId(pStack);
        MapItemSavedData mapItemSavedData = mapitemsaveddata = pLevel == null ? null : MapItem.getSavedData(integer, pLevel);
        if (mapitemsaveddata != null && mapitemsaveddata.locked) {
            pTooltip.add(new TranslatableComponent("filled_map.locked", integer).withStyle(ChatFormatting.GRAY));
        }
        if (pFlag.isAdvanced()) {
            if (mapitemsaveddata != null) {
                pTooltip.add(new TranslatableComponent("filled_map.id", integer).withStyle(ChatFormatting.GRAY));
                pTooltip.add(new TranslatableComponent("filled_map.scale", 1 << mapitemsaveddata.scale).withStyle(ChatFormatting.GRAY));
                pTooltip.add(new TranslatableComponent("filled_map.level", mapitemsaveddata.scale, 4).withStyle(ChatFormatting.GRAY));
            } else {
                pTooltip.add(new TranslatableComponent("filled_map.unknown").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public static int getColor(ItemStack pStack) {
        CompoundTag compoundtag = pStack.getTagElement("display");
        if (compoundtag != null && compoundtag.contains("MapColor", 99)) {
            int i = compoundtag.getInt("MapColor");
            return 0xFF000000 | i & 0xFFFFFF;
        }
        return -12173266;
    }

    @Override
    public InteractionResult useOn(UseOnContext pContext) {
        BlockState blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos());
        if (blockstate.is(BlockTags.BANNERS)) {
            MapItemSavedData mapitemsaveddata;
            if (!pContext.getLevel().isClientSide && (mapitemsaveddata = MapItem.getSavedData(pContext.getItemInHand(), pContext.getLevel())) != null && !mapitemsaveddata.toggleBanner(pContext.getLevel(), pContext.getClickedPos())) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.sidedSuccess(pContext.getLevel().isClientSide);
        }
        return super.useOn(pContext);
    }
}

