/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.authlib.GameProfile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.apache.commons.lang3.StringUtils;

public class PlayerHeadItem
extends StandingAndWallBlockItem {
    public static final String TAG_SKULL_OWNER = "SkullOwner";

    public PlayerHeadItem(Block p_42971_, Block p_42972_, Item.Properties p_42973_) {
        super(p_42971_, p_42972_, p_42973_);
    }

    @Override
    public Component getName(ItemStack pStack) {
        if (pStack.is(Items.PLAYER_HEAD) && pStack.hasTag()) {
            CompoundTag compoundtag1;
            String s = null;
            CompoundTag compoundtag = pStack.getTag();
            if (compoundtag.contains(TAG_SKULL_OWNER, 8)) {
                s = compoundtag.getString(TAG_SKULL_OWNER);
            } else if (compoundtag.contains(TAG_SKULL_OWNER, 10) && (compoundtag1 = compoundtag.getCompound(TAG_SKULL_OWNER)).contains("Name", 8)) {
                s = compoundtag1.getString("Name");
            }
            if (s != null) {
                return new TranslatableComponent(String.valueOf(this.getDescriptionId()) + ".named", s);
            }
        }
        return super.getName(pStack);
    }

    @Override
    public void verifyTagAfterLoad(CompoundTag pCompoundTag) {
        super.verifyTagAfterLoad(pCompoundTag);
        if (pCompoundTag.contains(TAG_SKULL_OWNER, 8) && !StringUtils.isBlank((CharSequence)pCompoundTag.getString(TAG_SKULL_OWNER))) {
            GameProfile gameprofile = new GameProfile(null, pCompoundTag.getString(TAG_SKULL_OWNER));
            SkullBlockEntity.updateGameprofile(gameprofile, p_151177_ -> pCompoundTag.put(TAG_SKULL_OWNER, NbtUtils.writeGameProfile(new CompoundTag(), p_151177_)));
        }
    }
}

