/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.state.BlockState;

public class ScaffoldingBlockItem
extends BlockItem {
    public ScaffoldingBlockItem(Block p_43060_, Item.Properties p_43061_) {
        super(p_43060_, p_43061_);
    }

    @Override
    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext pContext) {
        Block block;
        BlockPos blockpos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        BlockState blockstate = level.getBlockState(blockpos);
        if (!blockstate.is(block = this.getBlock())) {
            return ScaffoldingBlock.getDistance(level, blockpos) == 7 ? null : pContext;
        }
        Direction direction = pContext.isSecondaryUseActive() ? (pContext.isInside() ? pContext.getClickedFace().getOpposite() : pContext.getClickedFace()) : (pContext.getClickedFace() == Direction.UP ? pContext.getHorizontalDirection() : Direction.UP);
        int i = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockpos.mutable().move(direction);
        while (i < 7) {
            if (!level.isClientSide && !level.isInWorldBounds(blockpos$mutableblockpos)) {
                Player player = pContext.getPlayer();
                int j = level.getMaxBuildHeight();
                if (!(player instanceof ServerPlayer) || blockpos$mutableblockpos.getY() < j) break;
                ((ServerPlayer)player).sendMessage(new TranslatableComponent("build.tooHigh", j - 1).withStyle(ChatFormatting.RED), ChatType.GAME_INFO, Util.NIL_UUID);
                break;
            }
            blockstate = level.getBlockState(blockpos$mutableblockpos);
            if (!blockstate.is(this.getBlock())) {
                if (!blockstate.canBeReplaced(pContext)) break;
                return BlockPlaceContext.at(pContext, blockpos$mutableblockpos, direction);
            }
            blockpos$mutableblockpos.move(direction);
            if (!direction.getAxis().isHorizontal()) continue;
            ++i;
        }
        return null;
    }

    @Override
    protected boolean mustSurvive() {
        return false;
    }
}

