/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class ShovelItem
extends DiggerItem {
    protected static final Map<Block, BlockState> FLATTENABLES = Maps.newHashMap((Map)new ImmutableMap.Builder().put((Object)Blocks.GRASS_BLOCK, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.PODZOL, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.COARSE_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.MYCELIUM, (Object)Blocks.DIRT_PATH.defaultBlockState()).put((Object)Blocks.ROOTED_DIRT, (Object)Blocks.DIRT_PATH.defaultBlockState()).build());

    public ShovelItem(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pAttackDamageModifier, pAttackSpeedModifier, pTier, BlockTags.MINEABLE_WITH_SHOVEL, pProperties);
    }

    @Override
    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        if (pContext.getClickedFace() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = pContext.getPlayer();
        BlockState blockstate1 = FLATTENABLES.get(blockstate.getBlock());
        BlockState blockstate2 = null;
        if (blockstate1 != null && level.getBlockState(blockpos.above()).isAir()) {
            level.playSound(player, blockpos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.getBlock() instanceof CampfireBlock && blockstate.getValue(CampfireBlock.LIT).booleanValue()) {
            if (!level.isClientSide()) {
                level.levelEvent(null, 1009, blockpos, 0);
            }
            CampfireBlock.dowse(pContext.getPlayer(), level, blockpos, blockstate);
            blockstate2 = (BlockState)blockstate.setValue(CampfireBlock.LIT, false);
        }
        if (blockstate2 != null) {
            if (!level.isClientSide) {
                level.setBlock(blockpos, blockstate2, 11);
                if (player != null) {
                    pContext.getItemInHand().hurtAndBreak(1, player, p_43122_ -> p_43122_.broadcastBreakEvent(pContext.getHand()));
                }
            }
            return InteractionResult.sidedSuccess(level.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

