/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;

public class StandingAndWallBlockItem
extends BlockItem {
    protected final Block wallBlock;

    public StandingAndWallBlockItem(Block pStandingBlock, Block pWallBlock, Item.Properties pProperties) {
        super(pStandingBlock, pProperties);
        this.wallBlock = pWallBlock;
    }

    @Override
    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext pContext) {
        BlockState blockstate = this.wallBlock.getStateForPlacement(pContext);
        BlockState blockstate1 = null;
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        Direction[] directionArray = pContext.getNearestLookingDirections();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (direction != Direction.UP) {
                BlockState blockstate2;
                BlockState blockState = blockstate2 = direction == Direction.DOWN ? this.getBlock().getStateForPlacement(pContext) : blockstate;
                if (blockstate2 != null && blockstate2.canSurvive(levelreader, blockpos)) {
                    blockstate1 = blockstate2;
                    break;
                }
            }
            ++n2;
        }
        return blockstate1 != null && levelreader.isUnobstructed(blockstate1, blockpos, CollisionContext.empty()) ? blockstate1 : null;
    }

    @Override
    public void registerBlocks(Map<Block, Item> pBlockToItemMap, Item pItem) {
        super.registerBlocks(pBlockToItemMap, pItem);
        pBlockToItemMap.put(this.wallBlock, pItem);
    }
}

