/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class SuspiciousStewItem
extends Item {
    public static final String EFFECTS_TAG = "Effects";
    public static final String EFFECT_ID_TAG = "EffectId";
    public static final String EFFECT_DURATION_TAG = "EffectDuration";

    public SuspiciousStewItem(Item.Properties p_43257_) {
        super(p_43257_);
    }

    public static void saveMobEffect(ItemStack pBowlStack, MobEffect pEffect, int pEffectDuration) {
        CompoundTag compoundtag = pBowlStack.getOrCreateTag();
        ListTag listtag = compoundtag.getList(EFFECTS_TAG, 9);
        CompoundTag compoundtag1 = new CompoundTag();
        compoundtag1.putByte(EFFECT_ID_TAG, (byte)MobEffect.getId(pEffect));
        compoundtag1.putInt(EFFECT_DURATION_TAG, pEffectDuration);
        listtag.add(compoundtag1);
        compoundtag.put(EFFECTS_TAG, listtag);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        ItemStack itemstack = super.finishUsingItem(pStack, pLevel, pEntityLiving);
        CompoundTag compoundtag = pStack.getTag();
        if (compoundtag != null && compoundtag.contains(EFFECTS_TAG, 9)) {
            ListTag listtag = compoundtag.getList(EFFECTS_TAG, 10);
            int i = 0;
            while (i < listtag.size()) {
                MobEffect mobeffect;
                int j = 160;
                CompoundTag compoundtag1 = listtag.getCompound(i);
                if (compoundtag1.contains(EFFECT_DURATION_TAG, 3)) {
                    j = compoundtag1.getInt(EFFECT_DURATION_TAG);
                }
                if ((mobeffect = MobEffect.byId(compoundtag1.getByte(EFFECT_ID_TAG))) != null) {
                    pEntityLiving.addEffect(new MobEffectInstance(mobeffect, j));
                }
                ++i;
            }
        }
        return pEntityLiving instanceof Player && ((Player)pEntityLiving).getAbilities().instabuild ? itemstack : new ItemStack(Items.BOWL);
    }
}

