/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;

public class WrittenBookItem
extends Item {
    public static final int TITLE_LENGTH = 16;
    public static final int TITLE_MAX_LENGTH = 32;
    public static final int PAGE_EDIT_LENGTH = 1024;
    public static final int PAGE_LENGTH = Short.MAX_VALUE;
    public static final int MAX_PAGES = 100;
    public static final int MAX_GENERATION = 2;
    public static final String TAG_TITLE = "title";
    public static final String TAG_FILTERED_TITLE = "filtered_title";
    public static final String TAG_AUTHOR = "author";
    public static final String TAG_PAGES = "pages";
    public static final String TAG_FILTERED_PAGES = "filtered_pages";
    public static final String TAG_GENERATION = "generation";
    public static final String TAG_RESOLVED = "resolved";

    public WrittenBookItem(Item.Properties p_43455_) {
        super(p_43455_);
    }

    public static boolean makeSureTagIsValid(@Nullable CompoundTag pCompoundTag) {
        if (!WritableBookItem.makeSureTagIsValid(pCompoundTag)) {
            return false;
        }
        if (!pCompoundTag.contains(TAG_TITLE, 8)) {
            return false;
        }
        String s = pCompoundTag.getString(TAG_TITLE);
        return s.length() > 32 ? false : pCompoundTag.contains(TAG_AUTHOR, 8);
    }

    public static int getGeneration(ItemStack pBookStack) {
        return pBookStack.getTag().getInt(TAG_GENERATION);
    }

    public static int getPageCount(ItemStack pBookSTack) {
        CompoundTag compoundtag = pBookSTack.getTag();
        return compoundtag != null ? compoundtag.getList(TAG_PAGES, 8).size() : 0;
    }

    @Override
    public Component getName(ItemStack pStack) {
        String s;
        CompoundTag compoundtag = pStack.getTag();
        if (compoundtag != null && !StringUtil.isNullOrEmpty(s = compoundtag.getString(TAG_TITLE))) {
            return new TextComponent(s);
        }
        return super.getName(pStack);
    }

    @Override
    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (pStack.hasTag()) {
            CompoundTag compoundtag = pStack.getTag();
            String s = compoundtag.getString(TAG_AUTHOR);
            if (!StringUtil.isNullOrEmpty(s)) {
                pTooltip.add(new TranslatableComponent("book.byAuthor", s).withStyle(ChatFormatting.GRAY));
            }
            pTooltip.add(new TranslatableComponent("book.generation." + compoundtag.getInt(TAG_GENERATION)).withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos blockpos;
        Level level = pContext.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = pContext.getClickedPos());
        if (blockstate.is(Blocks.LECTERN)) {
            return LecternBlock.tryPlaceBook(pContext.getPlayer(), level, blockpos, blockstate, pContext.getItemInHand()) ? InteractionResult.sidedSuccess(level.isClientSide) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        pPlayer.openItemGui(itemstack, pHand);
        pPlayer.awardStat(Stats.ITEM_USED.get(this));
        return InteractionResultHolder.sidedSuccess(itemstack, pLevel.isClientSide());
    }

    public static boolean resolveBookComponents(ItemStack pBookStack, @Nullable CommandSourceStack pResolvingSource, @Nullable Player pResolvingPlayer) {
        CompoundTag compoundtag = pBookStack.getTag();
        if (compoundtag != null && !compoundtag.getBoolean(TAG_RESOLVED)) {
            compoundtag.putBoolean(TAG_RESOLVED, true);
            if (!WrittenBookItem.makeSureTagIsValid(compoundtag)) {
                return false;
            }
            ListTag listtag = compoundtag.getList(TAG_PAGES, 8);
            int i = 0;
            while (i < listtag.size()) {
                listtag.set(i, StringTag.valueOf(WrittenBookItem.resolvePage(pResolvingSource, pResolvingPlayer, listtag.getString(i))));
                ++i;
            }
            if (compoundtag.contains(TAG_FILTERED_PAGES, 10)) {
                CompoundTag compoundtag1 = compoundtag.getCompound(TAG_FILTERED_PAGES);
                for (String s : compoundtag1.getAllKeys()) {
                    compoundtag1.putString(s, WrittenBookItem.resolvePage(pResolvingSource, pResolvingPlayer, compoundtag1.getString(s)));
                }
            }
            return true;
        }
        return false;
    }

    private static String resolvePage(@Nullable CommandSourceStack pResolvingSource, @Nullable Player pResolvingPlayer, String pResolvingPageContents) {
        MutableComponent component;
        try {
            component = Component.Serializer.fromJsonLenient(pResolvingPageContents);
            component = ComponentUtils.updateForEntity(pResolvingSource, component, (Entity)pResolvingPlayer, 0);
        }
        catch (Exception exception) {
            component = new TextComponent(pResolvingPageContents);
        }
        return Component.Serializer.toJson(component);
    }

    @Override
    public boolean isFoil(ItemStack pStack) {
        return true;
    }
}

