/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;

public class Potion {
    @Nullable
    private final String name;
    private final ImmutableList<MobEffectInstance> effects;

    public static Potion byName(String pName) {
        return Registry.POTION.get(ResourceLocation.tryParse(pName));
    }

    public Potion(MobEffectInstance ... pEffects) {
        this((String)null, pEffects);
    }

    public Potion(@Nullable String pName, MobEffectInstance ... pEffects) {
        this.name = pName;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
    }

    public String getName(String pPrefix) {
        return String.valueOf(pPrefix) + (this.name == null ? Registry.POTION.getKey(this).getPath() : this.name);
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public boolean hasInstantEffects() {
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance mobeffectinstance : this.effects) {
                if (!mobeffectinstance.getEffect().isInstantenous()) continue;
                return true;
            }
        }
        return false;
    }
}

