/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.optifine.Config;
import net.optifine.CustomColors;

public class PotionUtils {
    public static final String TAG_CUSTOM_POTION_EFFECTS = "CustomPotionEffects";
    public static final String TAG_CUSTOM_POTION_COLOR = "CustomPotionColor";
    public static final String TAG_POTION = "Potion";
    private static final int EMPTY_COLOR = 0xF800F8;
    private static final Component NO_EFFECT = new TranslatableComponent("effect.none").withStyle(ChatFormatting.GRAY);

    public static List<MobEffectInstance> getMobEffects(ItemStack pStack) {
        return PotionUtils.getAllEffects(pStack.getTag());
    }

    public static List<MobEffectInstance> getAllEffects(Potion pPotion, Collection<MobEffectInstance> pEffects) {
        ArrayList list = Lists.newArrayList();
        list.addAll(pPotion.getEffects());
        list.addAll(pEffects);
        return list;
    }

    public static List<MobEffectInstance> getAllEffects(@Nullable CompoundTag pCompoundTag) {
        ArrayList list = Lists.newArrayList();
        list.addAll(PotionUtils.getPotion(pCompoundTag).getEffects());
        PotionUtils.getCustomEffects(pCompoundTag, list);
        return list;
    }

    public static List<MobEffectInstance> getCustomEffects(ItemStack pCompoundTag) {
        return PotionUtils.getCustomEffects(pCompoundTag.getTag());
    }

    public static List<MobEffectInstance> getCustomEffects(@Nullable CompoundTag pCompoundTag) {
        ArrayList list = Lists.newArrayList();
        PotionUtils.getCustomEffects(pCompoundTag, list);
        return list;
    }

    public static void getCustomEffects(@Nullable CompoundTag pCompoundTag, List<MobEffectInstance> pEffectList) {
        if (pCompoundTag != null && pCompoundTag.contains(TAG_CUSTOM_POTION_EFFECTS, 9)) {
            ListTag listtag = pCompoundTag.getList(TAG_CUSTOM_POTION_EFFECTS, 10);
            int i = 0;
            while (i < listtag.size()) {
                CompoundTag compoundtag = listtag.getCompound(i);
                MobEffectInstance mobeffectinstance = MobEffectInstance.load(compoundtag);
                if (mobeffectinstance != null) {
                    pEffectList.add(mobeffectinstance);
                }
                ++i;
            }
        }
    }

    public static int getColor(ItemStack pEffects) {
        CompoundTag compoundtag = pEffects.getTag();
        if (compoundtag != null && compoundtag.contains(TAG_CUSTOM_POTION_COLOR, 99)) {
            return compoundtag.getInt(TAG_CUSTOM_POTION_COLOR);
        }
        return PotionUtils.getPotion(pEffects) == Potions.EMPTY ? 0xF800F8 : PotionUtils.getColor(PotionUtils.getMobEffects(pEffects));
    }

    public static int getColor(Potion pEffects) {
        return pEffects == Potions.EMPTY ? 0xF800F8 : PotionUtils.getColor(pEffects.getEffects());
    }

    public static int getColor(Collection<MobEffectInstance> pEffects) {
        int i = 3694022;
        if (pEffects.isEmpty()) {
            return Config.isCustomColors() ? CustomColors.getPotionColor(null, i) : 3694022;
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int j = 0;
        for (MobEffectInstance mobeffectinstance : pEffects) {
            if (!mobeffectinstance.isVisible()) continue;
            int k = mobeffectinstance.getEffect().getColor();
            if (Config.isCustomColors()) {
                k = CustomColors.getPotionColor(mobeffectinstance.getEffect(), k);
            }
            int l = mobeffectinstance.getAmplifier() + 1;
            f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
            f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
            f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
            j += l;
        }
        if (j == 0) {
            return 0;
        }
        f = f / (float)j * 255.0f;
        f1 = f1 / (float)j * 255.0f;
        f2 = f2 / (float)j * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public static Potion getPotion(ItemStack pCompoundTag) {
        return PotionUtils.getPotion(pCompoundTag.getTag());
    }

    public static Potion getPotion(@Nullable CompoundTag pCompoundTag) {
        return pCompoundTag == null ? Potions.EMPTY : Potion.byName(pCompoundTag.getString(TAG_POTION));
    }

    public static ItemStack setPotion(ItemStack pStack, Potion pPotion) {
        ResourceLocation resourcelocation = Registry.POTION.getKey(pPotion);
        if (pPotion == Potions.EMPTY) {
            pStack.removeTagKey(TAG_POTION);
        } else {
            pStack.getOrCreateTag().putString(TAG_POTION, resourcelocation.toString());
        }
        return pStack;
    }

    public static ItemStack setCustomEffects(ItemStack pStack, Collection<MobEffectInstance> pEffects) {
        if (pEffects.isEmpty()) {
            return pStack;
        }
        CompoundTag compoundtag = pStack.getOrCreateTag();
        ListTag listtag = compoundtag.getList(TAG_CUSTOM_POTION_EFFECTS, 9);
        for (MobEffectInstance mobeffectinstance : pEffects) {
            listtag.add(mobeffectinstance.save(new CompoundTag()));
        }
        compoundtag.put(TAG_CUSTOM_POTION_EFFECTS, listtag);
        return pStack;
    }

    public static void addPotionTooltip(ItemStack pStack, List<Component> pTooltips, float pDurationFactor) {
        List<MobEffectInstance> list = PotionUtils.getMobEffects(pStack);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            pTooltips.add(NO_EFFECT);
        } else {
            for (MobEffectInstance mobeffectinstance : list) {
                TranslatableComponent mutablecomponent = new TranslatableComponent(mobeffectinstance.getDescriptionId());
                MobEffect mobeffect = mobeffectinstance.getEffect();
                Map<Attribute, AttributeModifier> map = mobeffect.getAttributeModifiers();
                if (!map.isEmpty()) {
                    for (Map.Entry<Attribute, AttributeModifier> entry : map.entrySet()) {
                        AttributeModifier attributemodifier = entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.getName(), mobeffect.getAttributeModifierValue(mobeffectinstance.getAmplifier(), attributemodifier), attributemodifier.getOperation());
                        list1.add(new Pair((Object)entry.getKey(), (Object)attributemodifier1));
                    }
                }
                if (mobeffectinstance.getAmplifier() > 0) {
                    mutablecomponent = new TranslatableComponent("potion.withAmplifier", mutablecomponent, new TranslatableComponent("potion.potency." + mobeffectinstance.getAmplifier()));
                }
                if (mobeffectinstance.getDuration() > 20) {
                    mutablecomponent = new TranslatableComponent("potion.withDuration", mutablecomponent, MobEffectUtil.formatDuration(mobeffectinstance, pDurationFactor));
                }
                pTooltips.add(mutablecomponent.withStyle(mobeffect.getCategory().getTooltipFormatting()));
            }
        }
        if (!list1.isEmpty()) {
            pTooltips.add(TextComponent.EMPTY);
            pTooltips.add(new TranslatableComponent("potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.getAmount();
                double d1 = attributemodifier2.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.getAmount() : attributemodifier2.getAmount() * 100.0;
                if (d0 > 0.0) {
                    pTooltips.add(new TranslatableComponent("attribute.modifier.plus." + attributemodifier2.getOperation().toValue(), ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1), new TranslatableComponent(((Attribute)pair.getFirst()).getDescriptionId())).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                pTooltips.add(new TranslatableComponent("attribute.modifier.take." + attributemodifier2.getOperation().toValue(), ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), new TranslatableComponent(((Attribute)pair.getFirst()).getDescriptionId())).withStyle(ChatFormatting.RED));
            }
        }
    }
}

