/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerBlockEntity;

public class BannerDuplicateRecipe
extends CustomRecipe {
    public BannerDuplicateRecipe(ResourceLocation p_43773_) {
        super(p_43773_);
    }

    @Override
    public boolean matches(CraftingContainer pInv, Level pLevel) {
        DyeColor dyecolor = null;
        ItemStack itemstack = null;
        ItemStack itemstack1 = null;
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack2 = pInv.getItem(i);
            if (!itemstack2.isEmpty()) {
                Item item = itemstack2.getItem();
                if (!(item instanceof BannerItem)) {
                    return false;
                }
                BannerItem banneritem = (BannerItem)item;
                if (dyecolor == null) {
                    dyecolor = banneritem.getColor();
                } else if (dyecolor != banneritem.getColor()) {
                    return false;
                }
                int j = BannerBlockEntity.getPatternCount(itemstack2);
                if (j > 6) {
                    return false;
                }
                if (j > 0) {
                    if (itemstack != null) {
                        return false;
                    }
                    itemstack = itemstack2;
                } else {
                    if (itemstack1 != null) {
                        return false;
                    }
                    itemstack1 = itemstack2;
                }
            }
            ++i;
        }
        return itemstack != null && itemstack1 != null;
    }

    @Override
    public ItemStack assemble(CraftingContainer pInv) {
        int i = 0;
        while (i < pInv.getContainerSize()) {
            int j;
            ItemStack itemstack = pInv.getItem(i);
            if (!itemstack.isEmpty() && (j = BannerBlockEntity.getPatternCount(itemstack)) > 0 && j <= 6) {
                ItemStack itemstack1 = itemstack.copy();
                itemstack1.setCount(1);
                return itemstack1;
            }
            ++i;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer pInv) {
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(pInv.getContainerSize(), ItemStack.EMPTY);
        int i = 0;
        while (i < nonnulllist.size()) {
            ItemStack itemstack = pInv.getItem(i);
            if (!itemstack.isEmpty()) {
                if (itemstack.getItem().hasCraftingRemainingItem()) {
                    nonnulllist.set(i, new ItemStack(itemstack.getItem().getCraftingRemainingItem()));
                } else if (itemstack.hasTag() && BannerBlockEntity.getPatternCount(itemstack) > 0) {
                    ItemStack itemstack1 = itemstack.copy();
                    itemstack1.setCount(1);
                    nonnulllist.set(i, itemstack1);
                }
            }
            ++i;
        }
        return nonnulllist;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.BANNER_DUPLICATE;
    }

    @Override
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }
}

