/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FireworkRocketRecipe
extends CustomRecipe {
    private static final Ingredient PAPER_INGREDIENT = Ingredient.a(Items.PAPER);
    private static final Ingredient GUNPOWDER_INGREDIENT = Ingredient.a(Items.GUNPOWDER);
    private static final Ingredient STAR_INGREDIENT = Ingredient.a(Items.FIREWORK_STAR);

    public FireworkRocketRecipe(ResourceLocation p_43842_) {
        super(p_43842_);
    }

    @Override
    public boolean matches(CraftingContainer pInv, Level pLevel) {
        boolean flag = false;
        int i = 0;
        int j = 0;
        while (j < pInv.getContainerSize()) {
            ItemStack itemstack = pInv.getItem(j);
            if (!itemstack.isEmpty()) {
                if (PAPER_INGREDIENT.test(itemstack)) {
                    if (flag) {
                        return false;
                    }
                    flag = true;
                } else if (GUNPOWDER_INGREDIENT.test(itemstack) ? ++i > 3 : !STAR_INGREDIENT.test(itemstack)) {
                    return false;
                }
            }
            ++j;
        }
        return flag && i >= 1;
    }

    @Override
    public ItemStack assemble(CraftingContainer pInv) {
        ItemStack itemstack = new ItemStack(Items.FIREWORK_ROCKET, 3);
        CompoundTag compoundtag = itemstack.getOrCreateTagElement("Fireworks");
        ListTag listtag = new ListTag();
        int i = 0;
        int j = 0;
        while (j < pInv.getContainerSize()) {
            ItemStack itemstack1 = pInv.getItem(j);
            if (!itemstack1.isEmpty()) {
                CompoundTag compoundtag1;
                if (GUNPOWDER_INGREDIENT.test(itemstack1)) {
                    ++i;
                } else if (STAR_INGREDIENT.test(itemstack1) && (compoundtag1 = itemstack1.getTagElement("Explosion")) != null) {
                    listtag.add(compoundtag1);
                }
            }
            ++j;
        }
        compoundtag.putByte("Flight", (byte)i);
        if (!listtag.isEmpty()) {
            compoundtag.put("Explosions", listtag);
        }
        return itemstack;
    }

    @Override
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @Override
    public ItemStack getResultItem() {
        return new ItemStack(Items.FIREWORK_ROCKET);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_ROCKET;
    }
}

