/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FireworkStarFadeRecipe
extends CustomRecipe {
    private static final Ingredient STAR_INGREDIENT = Ingredient.a(Items.FIREWORK_STAR);

    public FireworkStarFadeRecipe(ResourceLocation p_43861_) {
        super(p_43861_);
    }

    @Override
    public boolean matches(CraftingContainer pInv, Level pLevel) {
        boolean flag = false;
        boolean flag1 = false;
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack = pInv.getItem(i);
            if (!itemstack.isEmpty()) {
                if (itemstack.getItem() instanceof DyeItem) {
                    flag = true;
                } else {
                    if (!STAR_INGREDIENT.test(itemstack)) {
                        return false;
                    }
                    if (flag1) {
                        return false;
                    }
                    flag1 = true;
                }
            }
            ++i;
        }
        return flag1 && flag;
    }

    @Override
    public ItemStack assemble(CraftingContainer pInv) {
        ArrayList list = Lists.newArrayList();
        ItemStack itemstack = null;
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack1 = pInv.getItem(i);
            Item item = itemstack1.getItem();
            if (item instanceof DyeItem) {
                list.add(((DyeItem)item).getDyeColor().getFireworkColor());
            } else if (STAR_INGREDIENT.test(itemstack1)) {
                itemstack = itemstack1.copy();
                itemstack.setCount(1);
            }
            ++i;
        }
        if (itemstack != null && !list.isEmpty()) {
            itemstack.getOrCreateTagElement("Explosion").putIntArray("FadeColors", list);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR_FADE;
    }
}

