/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FireworkStarRecipe
extends CustomRecipe {
    private static final Ingredient SHAPE_INGREDIENT = Ingredient.a(Items.FIRE_CHARGE, Items.FEATHER, Items.GOLD_NUGGET, Items.SKELETON_SKULL, Items.WITHER_SKELETON_SKULL, Items.CREEPER_HEAD, Items.PLAYER_HEAD, Items.DRAGON_HEAD, Items.ZOMBIE_HEAD);
    private static final Ingredient TRAIL_INGREDIENT = Ingredient.a(Items.DIAMOND);
    private static final Ingredient FLICKER_INGREDIENT = Ingredient.a(Items.GLOWSTONE_DUST);
    private static final Map<Item, FireworkRocketItem.Shape> SHAPE_BY_ITEM = Util.make(Maps.newHashMap(), p_43898_ -> {
        p_43898_.put(Items.FIRE_CHARGE, FireworkRocketItem.Shape.LARGE_BALL);
        p_43898_.put(Items.FEATHER, FireworkRocketItem.Shape.BURST);
        p_43898_.put(Items.GOLD_NUGGET, FireworkRocketItem.Shape.STAR);
        p_43898_.put(Items.SKELETON_SKULL, FireworkRocketItem.Shape.CREEPER);
        p_43898_.put(Items.WITHER_SKELETON_SKULL, FireworkRocketItem.Shape.CREEPER);
        p_43898_.put(Items.CREEPER_HEAD, FireworkRocketItem.Shape.CREEPER);
        p_43898_.put(Items.PLAYER_HEAD, FireworkRocketItem.Shape.CREEPER);
        p_43898_.put(Items.DRAGON_HEAD, FireworkRocketItem.Shape.CREEPER);
        p_43898_.put(Items.ZOMBIE_HEAD, FireworkRocketItem.Shape.CREEPER);
    });
    private static final Ingredient GUNPOWDER_INGREDIENT = Ingredient.a(Items.GUNPOWDER);

    public FireworkStarRecipe(ResourceLocation p_43883_) {
        super(p_43883_);
    }

    @Override
    public boolean matches(CraftingContainer pInv, Level pLevel) {
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack = pInv.getItem(i);
            if (!itemstack.isEmpty()) {
                if (SHAPE_INGREDIENT.test(itemstack)) {
                    if (flag2) {
                        return false;
                    }
                    flag2 = true;
                } else if (FLICKER_INGREDIENT.test(itemstack)) {
                    if (flag4) {
                        return false;
                    }
                    flag4 = true;
                } else if (TRAIL_INGREDIENT.test(itemstack)) {
                    if (flag3) {
                        return false;
                    }
                    flag3 = true;
                } else if (GUNPOWDER_INGREDIENT.test(itemstack)) {
                    if (flag) {
                        return false;
                    }
                    flag = true;
                } else {
                    if (!(itemstack.getItem() instanceof DyeItem)) {
                        return false;
                    }
                    flag1 = true;
                }
            }
            ++i;
        }
        return flag && flag1;
    }

    @Override
    public ItemStack assemble(CraftingContainer pInv) {
        ItemStack itemstack = new ItemStack(Items.FIREWORK_STAR);
        CompoundTag compoundtag = itemstack.getOrCreateTagElement("Explosion");
        FireworkRocketItem.Shape fireworkrocketitem$shape = FireworkRocketItem.Shape.SMALL_BALL;
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack1 = pInv.getItem(i);
            if (!itemstack1.isEmpty()) {
                if (SHAPE_INGREDIENT.test(itemstack1)) {
                    fireworkrocketitem$shape = SHAPE_BY_ITEM.get(itemstack1.getItem());
                } else if (FLICKER_INGREDIENT.test(itemstack1)) {
                    compoundtag.putBoolean("Flicker", true);
                } else if (TRAIL_INGREDIENT.test(itemstack1)) {
                    compoundtag.putBoolean("Trail", true);
                } else if (itemstack1.getItem() instanceof DyeItem) {
                    list.add(((DyeItem)itemstack1.getItem()).getDyeColor().getFireworkColor());
                }
            }
            ++i;
        }
        compoundtag.putIntArray("Colors", list);
        compoundtag.putByte("Type", (byte)fireworkrocketitem$shape.getId());
        return itemstack;
    }

    @Override
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @Override
    public ItemStack getResultItem() {
        return new ItemStack(Items.FIREWORK_STAR);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR;
    }
}

