/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public final class Ingredient
implements Predicate<ItemStack> {
    public static final Ingredient EMPTY = new Ingredient(Stream.empty());
    private final Value[] values;
    @Nullable
    private ItemStack[] itemStacks;
    @Nullable
    private IntList stackingIds;

    private Ingredient(Stream<? extends Value> pValues) {
        this.values = (Value[])pValues.toArray(Value[]::new);
    }

    public ItemStack[] getItems() {
        this.dissolve();
        return this.itemStacks;
    }

    private void dissolve() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.values).flatMap(p_43916_ -> p_43916_.getItems().stream()).distinct().toArray(ItemStack[]::new);
        }
    }

    @Override
    public boolean test(@Nullable ItemStack p_43914_) {
        if (p_43914_ == null) {
            return false;
        }
        this.dissolve();
        if (this.itemStacks.length == 0) {
            return p_43914_.isEmpty();
        }
        ItemStack[] itemStackArray = this.itemStacks;
        int n = this.itemStacks.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack itemstack = itemStackArray[n2];
            if (itemstack.is(p_43914_.getItem())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IntList getStackingIds() {
        if (this.stackingIds == null) {
            this.dissolve();
            this.stackingIds = new IntArrayList(this.itemStacks.length);
            ItemStack[] itemStackArray = this.itemStacks;
            int n = this.itemStacks.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack itemstack = itemStackArray[n2];
                this.stackingIds.add(StackedContents.getStackingIndex(itemstack));
                ++n2;
            }
            this.stackingIds.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.stackingIds;
    }

    public void toNetwork(FriendlyByteBuf pBuffer) {
        this.dissolve();
        pBuffer.writeCollection(Arrays.asList(this.itemStacks), FriendlyByteBuf::writeItem);
    }

    public JsonElement toJson() {
        if (this.values.length == 1) {
            return this.values[0].serialize();
        }
        JsonArray jsonarray = new JsonArray();
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value ingredient$value = valueArray[n2];
            jsonarray.add((JsonElement)ingredient$value.serialize());
            ++n2;
        }
        return jsonarray;
    }

    public boolean isEmpty() {
        return !(this.values.length != 0 || this.itemStacks != null && this.itemStacks.length != 0 || this.stackingIds != null && !this.stackingIds.isEmpty());
    }

    private static Ingredient fromValues(Stream<? extends Value> pStream) {
        Ingredient ingredient = new Ingredient(pStream);
        return ingredient.values.length == 0 ? EMPTY : ingredient;
    }

    public static Ingredient of() {
        return EMPTY;
    }

    public static Ingredient a(ItemLike ... p_43930_) {
        return Ingredient.of(Arrays.stream(p_43930_).map(ItemStack::new));
    }

    public static Ingredient a(ItemStack ... p_43928_) {
        return Ingredient.of(Arrays.stream(p_43928_));
    }

    public static Ingredient of(Stream<ItemStack> pStacks) {
        return Ingredient.fromValues(pStacks.filter(p_43944_ -> !p_43944_.isEmpty()).map(ItemValue::new));
    }

    public static Ingredient of(TagKey<Item> pStacks) {
        return Ingredient.fromValues(Stream.of(new TagValue(pStacks)));
    }

    public static Ingredient fromNetwork(FriendlyByteBuf pBuffer) {
        return Ingredient.fromValues(pBuffer.readList(FriendlyByteBuf::readItem).stream().map(ItemValue::new));
    }

    public static Ingredient fromJson(@Nullable JsonElement pJson) {
        if (pJson != null && !pJson.isJsonNull()) {
            if (pJson.isJsonObject()) {
                return Ingredient.fromValues(Stream.of(Ingredient.valueFromJson(pJson.getAsJsonObject())));
            }
            if (pJson.isJsonArray()) {
                JsonArray jsonarray = pJson.getAsJsonArray();
                if (jsonarray.size() == 0) {
                    throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
                }
                return Ingredient.fromValues(StreamSupport.stream(jsonarray.spliterator(), false).map(p_151264_ -> Ingredient.valueFromJson(GsonHelper.convertToJsonObject(p_151264_, "item"))));
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }

    private static Value valueFromJson(JsonObject pJson) {
        if (pJson.has("item") && pJson.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (pJson.has("item")) {
            Item item = ShapedRecipe.itemFromJson(pJson);
            return new ItemValue(new ItemStack(item));
        }
        if (pJson.has("tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(pJson, "tag"));
            TagKey<Item> tagkey = TagKey.create(Registry.ITEM_REGISTRY, resourcelocation);
            return new TagValue(tagkey);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    static class ItemValue
    implements Value {
        private final ItemStack item;

        ItemValue(ItemStack pItem) {
            this.item = pItem;
        }

        @Override
        public Collection<ItemStack> getItems() {
            return Collections.singleton(this.item);
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("item", Registry.ITEM.getKey(this.item.getItem()).toString());
            return jsonobject;
        }
    }

    static class TagValue
    implements Value {
        private final TagKey<Item> tag;

        TagValue(TagKey<Item> pTag) {
            this.tag = pTag;
        }

        @Override
        public Collection<ItemStack> getItems() {
            ArrayList list = Lists.newArrayList();
            for (Holder<Item> holder : Registry.ITEM.getTagOrEmpty(this.tag)) {
                list.add(new ItemStack(holder));
            }
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.tag.location().toString());
            return jsonobject;
        }
    }

    static interface Value {
        public Collection<ItemStack> getItems();

        public JsonObject serialize();
    }
}

