/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapExtendingRecipe
extends ShapedRecipe {
    public MapExtendingRecipe(ResourceLocation pId) {
        super(pId, "", 3, 3, NonNullList.a(Ingredient.EMPTY, Ingredient.a(Items.PAPER), Ingredient.a(Items.PAPER), Ingredient.a(Items.PAPER), Ingredient.a(Items.PAPER), Ingredient.a(Items.FILLED_MAP), Ingredient.a(Items.PAPER), Ingredient.a(Items.PAPER), Ingredient.a(Items.PAPER), Ingredient.a(Items.PAPER)), new ItemStack(Items.MAP));
    }

    @Override
    public boolean matches(CraftingContainer pInv, Level pLevel) {
        if (!super.matches(pInv, pLevel)) {
            return false;
        }
        ItemStack itemstack = ItemStack.EMPTY;
        int i = 0;
        while (i < pInv.getContainerSize() && itemstack.isEmpty()) {
            ItemStack itemstack1 = pInv.getItem(i);
            if (itemstack1.is(Items.FILLED_MAP)) {
                itemstack = itemstack1;
            }
            ++i;
        }
        if (itemstack.isEmpty()) {
            return false;
        }
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData(itemstack, pLevel);
        if (mapitemsaveddata == null) {
            return false;
        }
        if (mapitemsaveddata.isExplorationMap()) {
            return false;
        }
        return mapitemsaveddata.scale < 4;
    }

    @Override
    public ItemStack assemble(CraftingContainer pInv) {
        ItemStack itemstack = ItemStack.EMPTY;
        int i = 0;
        while (i < pInv.getContainerSize() && itemstack.isEmpty()) {
            ItemStack itemstack1 = pInv.getItem(i);
            if (itemstack1.is(Items.FILLED_MAP)) {
                itemstack = itemstack1;
            }
            ++i;
        }
        itemstack = itemstack.copy();
        itemstack.setCount(1);
        itemstack.getOrCreateTag().putInt("map_scale_direction", 1);
        return itemstack;
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.MAP_EXTENDING;
    }
}

