/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class RecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> recipes = ImmutableMap.of();
    private Map<ResourceLocation, Recipe<?>> byName = ImmutableMap.of();
    private boolean hasErrors;

    public RecipeManager() {
        super(GSON, "recipes");
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.hasErrors = false;
        HashMap map = Maps.newHashMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            try {
                Recipe<?> recipe = RecipeManager.fromJson(resourcelocation, GsonHelper.convertToJsonObject(entry.getValue(), "top element"));
                map.computeIfAbsent(recipe.getType(), p_44075_ -> ImmutableMap.builder()).put((Object)resourcelocation, recipe);
                builder.put((Object)resourcelocation, recipe);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                LOGGER.error("Parsing error loading recipe {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        this.recipes = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_44033_ -> ((ImmutableMap.Builder)p_44033_.getValue()).build()));
        this.byName = builder.build();
        LOGGER.info("Loaded {} recipes", (Object)map.size());
    }

    public boolean hadErrorsLoading() {
        return this.hasErrors;
    }

    public <C extends Container, T extends Recipe<C>> Optional<T> getRecipeFor(RecipeType<T> pRecipeType, C pInventory, Level pLevel) {
        return this.byType(pRecipeType).values().stream().flatMap(p_44064_ -> pRecipeType.tryMatch(p_44064_, pLevel, pInventory).stream()).findFirst();
    }

    public <C extends Container, T extends Recipe<C>> List<T> getAllRecipesFor(RecipeType<T> pRecipeType) {
        return this.byType(pRecipeType).values().stream().map(p_44053_ -> p_44053_).collect(Collectors.toList());
    }

    public <C extends Container, T extends Recipe<C>> List<T> getRecipesFor(RecipeType<T> pRecipeType, C pInventory, Level pLevel) {
        return this.byType(pRecipeType).values().stream().flatMap(p_44023_ -> pRecipeType.tryMatch(p_44023_, pLevel, pInventory).stream()).sorted(Comparator.comparing(p_44012_ -> p_44012_.getResultItem().getDescriptionId())).collect(Collectors.toList());
    }

    private <C extends Container, T extends Recipe<C>> Map<ResourceLocation, Recipe<C>> byType(RecipeType<T> pRecipeType) {
        return this.recipes.getOrDefault(pRecipeType, Collections.emptyMap());
    }

    public <C extends Container, T extends Recipe<C>> NonNullList<ItemStack> getRemainingItemsFor(RecipeType<T> pRecipeType, C pInventory, Level pLevel) {
        Optional<T> optional = this.getRecipeFor(pRecipeType, pInventory, pLevel);
        if (optional.isPresent()) {
            return ((Recipe)optional.get()).getRemainingItems(pInventory);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.withSize(pInventory.getContainerSize(), ItemStack.EMPTY);
        int i = 0;
        while (i < nonnulllist.size()) {
            nonnulllist.set(i, pInventory.getItem(i));
            ++i;
        }
        return nonnulllist;
    }

    public Optional<? extends Recipe<?>> byKey(ResourceLocation pRecipeId) {
        return Optional.ofNullable(this.byName.get(pRecipeId));
    }

    public Collection<Recipe<?>> getRecipes() {
        return this.recipes.values().stream().flatMap(p_199910_ -> p_199910_.values().stream()).collect(Collectors.toSet());
    }

    public Stream<ResourceLocation> getRecipeIds() {
        return this.recipes.values().stream().flatMap(p_199904_ -> p_199904_.keySet().stream());
    }

    public static Recipe<?> fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
        String s = GsonHelper.getAsString(pJson, "type");
        return Registry.RECIPE_SERIALIZER.getOptional(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + s + "'")).fromJson(pRecipeId, pJson);
    }

    public void replaceRecipes(Iterable<Recipe<?>> pRecipes) {
        this.hasErrors = false;
        HashMap map = Maps.newHashMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        pRecipes.forEach(p_199908_ -> {
            Map map1 = map.computeIfAbsent(p_199908_.getType(), p_199912_ -> Maps.newHashMap());
            ResourceLocation resourcelocation = p_199908_.getId();
            Recipe recipe = map1.put(resourcelocation, p_199908_);
            builder.put((Object)resourcelocation, p_199908_);
            if (recipe != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + resourcelocation);
            }
        });
        this.recipes = ImmutableMap.copyOf((Map)map);
        this.byName = builder.build();
    }
}

