/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class RepairItemRecipe
extends CustomRecipe {
    public RepairItemRecipe(ResourceLocation p_44126_) {
        super(p_44126_);
    }

    @Override
    public boolean matches(CraftingContainer pInv, Level pLevel) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack = pInv.getItem(i);
            if (!itemstack.isEmpty()) {
                ItemStack itemstack1;
                list.add(itemstack);
                if (!(list.size() <= 1 || itemstack.is((itemstack1 = (ItemStack)list.get(0)).getItem()) && itemstack1.getCount() == 1 && itemstack.getCount() == 1 && itemstack1.getItem().canBeDepleted())) {
                    return false;
                }
            }
            ++i;
        }
        return list.size() == 2;
    }

    @Override
    public ItemStack assemble(CraftingContainer pInv) {
        ItemStack itemstack4;
        ItemStack itemstack3;
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack = pInv.getItem(i);
            if (!itemstack.isEmpty()) {
                ItemStack itemstack1;
                list.add(itemstack);
                if (!(list.size() <= 1 || itemstack.is((itemstack1 = (ItemStack)list.get(0)).getItem()) && itemstack1.getCount() == 1 && itemstack.getCount() == 1 && itemstack1.getItem().canBeDepleted())) {
                    return ItemStack.EMPTY;
                }
            }
            ++i;
        }
        if (list.size() == 2 && (itemstack3 = (ItemStack)list.get(0)).is((itemstack4 = (ItemStack)list.get(1)).getItem()) && itemstack3.getCount() == 1 && itemstack4.getCount() == 1 && itemstack3.getItem().canBeDepleted()) {
            Item item = itemstack3.getItem();
            int j = item.getMaxDamage() - itemstack3.getDamageValue();
            int k = item.getMaxDamage() - itemstack4.getDamageValue();
            int l = j + k + item.getMaxDamage() * 5 / 100;
            int i1 = item.getMaxDamage() - l;
            if (i1 < 0) {
                i1 = 0;
            }
            ItemStack itemstack2 = new ItemStack(itemstack3.getItem());
            itemstack2.setDamageValue(i1);
            HashMap map = Maps.newHashMap();
            Map<Enchantment, Integer> map1 = EnchantmentHelper.getEnchantments(itemstack3);
            Map<Enchantment, Integer> map2 = EnchantmentHelper.getEnchantments(itemstack4);
            Registry.ENCHANTMENT.stream().filter(Enchantment::isCurse).forEach(p_44144_ -> {
                int j1 = Math.max(map1.getOrDefault(p_44144_, 0), map2.getOrDefault(p_44144_, 0));
                if (j1 > 0) {
                    map.put(p_44144_, j1);
                }
            });
            if (!map.isEmpty()) {
                EnchantmentHelper.setEnchantments(map, itemstack2);
            }
            return itemstack2;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.REPAIR_ITEM;
    }
}

