/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ShieldDecorationRecipe
extends CustomRecipe {
    public ShieldDecorationRecipe(ResourceLocation p_44296_) {
        super(p_44296_);
    }

    @Override
    public boolean matches(CraftingContainer pInv, Level pLevel) {
        ItemStack itemstack = ItemStack.EMPTY;
        ItemStack itemstack1 = ItemStack.EMPTY;
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack2 = pInv.getItem(i);
            if (!itemstack2.isEmpty()) {
                if (itemstack2.getItem() instanceof BannerItem) {
                    if (!itemstack1.isEmpty()) {
                        return false;
                    }
                    itemstack1 = itemstack2;
                } else {
                    if (!itemstack2.is(Items.SHIELD)) {
                        return false;
                    }
                    if (!itemstack.isEmpty()) {
                        return false;
                    }
                    if (BlockItem.getBlockEntityData(itemstack2) != null) {
                        return false;
                    }
                    itemstack = itemstack2;
                }
            }
            ++i;
        }
        return !itemstack.isEmpty() && !itemstack1.isEmpty();
    }

    @Override
    public ItemStack assemble(CraftingContainer pInv) {
        ItemStack itemstack = ItemStack.EMPTY;
        ItemStack itemstack1 = ItemStack.EMPTY;
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack2 = pInv.getItem(i);
            if (!itemstack2.isEmpty()) {
                if (itemstack2.getItem() instanceof BannerItem) {
                    itemstack = itemstack2;
                } else if (itemstack2.is(Items.SHIELD)) {
                    itemstack1 = itemstack2.copy();
                }
            }
            ++i;
        }
        if (itemstack1.isEmpty()) {
            return itemstack1;
        }
        CompoundTag compoundtag = BlockItem.getBlockEntityData(itemstack);
        CompoundTag compoundtag1 = compoundtag == null ? new CompoundTag() : compoundtag.copy();
        compoundtag1.putInt("Base", ((BannerItem)itemstack.getItem()).getColor().getId());
        BlockItem.setBlockEntityData(itemstack1, BlockEntityType.BANNER, compoundtag1);
        return itemstack1;
    }

    @Override
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHIELD_DECORATION;
    }
}

