/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;

public class SuspiciousStewRecipe
extends CustomRecipe {
    public SuspiciousStewRecipe(ResourceLocation p_44487_) {
        super(p_44487_);
    }

    @Override
    public boolean matches(CraftingContainer pInv, Level pLevel) {
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack = pInv.getItem(i);
            if (!itemstack.isEmpty()) {
                if (itemstack.is(Blocks.BROWN_MUSHROOM.asItem()) && !flag2) {
                    flag2 = true;
                } else if (itemstack.is(Blocks.RED_MUSHROOM.asItem()) && !flag1) {
                    flag1 = true;
                } else if (itemstack.is(ItemTags.SMALL_FLOWERS) && !flag) {
                    flag = true;
                } else {
                    if (!itemstack.is(Items.BOWL) || flag3) {
                        return false;
                    }
                    flag3 = true;
                }
            }
            ++i;
        }
        return flag && flag2 && flag1 && flag3;
    }

    @Override
    public ItemStack assemble(CraftingContainer pInv) {
        ItemStack itemstack = ItemStack.EMPTY;
        int i = 0;
        while (i < pInv.getContainerSize()) {
            ItemStack itemstack1 = pInv.getItem(i);
            if (!itemstack1.isEmpty() && itemstack1.is(ItemTags.SMALL_FLOWERS)) {
                itemstack = itemstack1;
                break;
            }
            ++i;
        }
        ItemStack itemstack2 = new ItemStack(Items.SUSPICIOUS_STEW, 1);
        if (itemstack.getItem() instanceof BlockItem && ((BlockItem)itemstack.getItem()).getBlock() instanceof FlowerBlock) {
            FlowerBlock flowerblock = (FlowerBlock)((BlockItem)itemstack.getItem()).getBlock();
            MobEffect mobeffect = flowerblock.getSuspiciousStewEffect();
            SuspiciousStewItem.saveMobEffect(itemstack2, mobeffect, flowerblock.getEffectDuration());
        }
        return itemstack2;
    }

    @Override
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth >= 2 && pHeight >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SUSPICIOUS_STEW;
    }
}

