/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class TippedArrowRecipe
extends CustomRecipe {
    public TippedArrowRecipe(ResourceLocation p_44503_) {
        super(p_44503_);
    }

    @Override
    public boolean matches(CraftingContainer pInv, Level pLevel) {
        if (pInv.getWidth() == 3 && pInv.getHeight() == 3) {
            int i = 0;
            while (i < pInv.getWidth()) {
                int j = 0;
                while (j < pInv.getHeight()) {
                    ItemStack itemstack = pInv.getItem(i + j * pInv.getWidth());
                    if (itemstack.isEmpty()) {
                        return false;
                    }
                    if (i == 1 && j == 1 ? !itemstack.is(Items.LINGERING_POTION) : !itemstack.is(Items.ARROW)) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack assemble(CraftingContainer pInv) {
        ItemStack itemstack = pInv.getItem(1 + pInv.getWidth());
        if (!itemstack.is(Items.LINGERING_POTION)) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack1 = new ItemStack(Items.TIPPED_ARROW, 8);
        PotionUtils.setPotion(itemstack1, PotionUtils.getPotion(itemstack));
        PotionUtils.setCustomEffects(itemstack1, PotionUtils.getCustomEffects(itemstack));
        return itemstack1;
    }

    @Override
    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth >= 2 && pHeight >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.TIPPED_ARROW;
    }
}

