/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.Random;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class DigDurabilityEnchantment
extends Enchantment {
    protected DigDurabilityEnchantment(Enchantment.Rarity pRarity, EquipmentSlot ... pApplicableSlots) {
        super(pRarity, EnchantmentCategory.BREAKABLE, pApplicableSlots);
    }

    @Override
    public int getMinCost(int pEnchantmentLevel) {
        return 5 + (pEnchantmentLevel - 1) * 8;
    }

    @Override
    public int getMaxCost(int pEnchantmentLevel) {
        return super.getMinCost(pEnchantmentLevel) + 50;
    }

    @Override
    public int getMaxLevel() {
        return 3;
    }

    @Override
    public boolean canEnchant(ItemStack pStack) {
        return pStack.isDamageableItem() ? true : super.canEnchant(pStack);
    }

    public static boolean shouldIgnoreDurabilityDrop(ItemStack pStack, int pLevel, Random pRand) {
        if (pStack.getItem() instanceof ArmorItem && pRand.nextFloat() < 0.6f) {
            return false;
        }
        return pRand.nextInt(pLevel + 1) > 0;
    }
}

