/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public abstract class Enchantment {
    private final EquipmentSlot[] slots;
    private final Rarity rarity;
    public final EnchantmentCategory category;
    @Nullable
    protected String descriptionId;

    @Nullable
    public static Enchantment byId(int pId) {
        return (Enchantment)Registry.ENCHANTMENT.byId(pId);
    }

    protected Enchantment(Rarity pRarity, EnchantmentCategory pCategory, EquipmentSlot[] pApplicableSlots) {
        this.rarity = pRarity;
        this.category = pCategory;
        this.slots = pApplicableSlots;
    }

    public Map<EquipmentSlot, ItemStack> getSlotItems(LivingEntity pEntity) {
        EnumMap map = Maps.newEnumMap(EquipmentSlot.class);
        EquipmentSlot[] equipmentSlotArray = this.slots;
        int n = this.slots.length;
        int n2 = 0;
        while (n2 < n) {
            EquipmentSlot equipmentslot = equipmentSlotArray[n2];
            ItemStack itemstack = pEntity.getItemBySlot(equipmentslot);
            if (!itemstack.isEmpty()) {
                map.put(equipmentslot, itemstack);
            }
            ++n2;
        }
        return map;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public int getMinLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return 1;
    }

    public int getMinCost(int pLevel) {
        return 1 + pLevel * 10;
    }

    public int getMaxCost(int pLevel) {
        return this.getMinCost(pLevel) + 5;
    }

    public int getDamageProtection(int pLevel, DamageSource pSource) {
        return 0;
    }

    public float getDamageBonus(int pLevel, MobType pType) {
        return 0.0f;
    }

    public final boolean isCompatibleWith(Enchantment pOther) {
        return this.checkCompatibility(pOther) && pOther.checkCompatibility(this);
    }

    protected boolean checkCompatibility(Enchantment pOther) {
        return this != pOther;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId("enchantment", Registry.ENCHANTMENT.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public Component getFullname(int pLevel) {
        TranslatableComponent mutablecomponent = new TranslatableComponent(this.getDescriptionId());
        if (this.isCurse()) {
            mutablecomponent.withStyle(ChatFormatting.RED);
        } else {
            mutablecomponent.withStyle(ChatFormatting.GRAY);
        }
        if (pLevel != 1 || this.getMaxLevel() != 1) {
            mutablecomponent.append(" ").append(new TranslatableComponent("enchantment.level." + pLevel));
        }
        return mutablecomponent;
    }

    public boolean canEnchant(ItemStack pStack) {
        return this.category.canEnchant(pStack.getItem());
    }

    public void doPostAttack(LivingEntity pAttacker, Entity pTarget, int pLevel) {
    }

    public void doPostHurt(LivingEntity pUser, Entity pAttacker, int pLevel) {
    }

    public boolean isTreasureOnly() {
        return false;
    }

    public boolean isCurse() {
        return false;
    }

    public boolean isTradeable() {
        return true;
    }

    public boolean isDiscoverable() {
        return true;
    }

    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int weight;

        private Rarity(int p_44715_) {
            this.weight = p_44715_;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

